/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas.forge.events;

import com.natamus.areas_common_forge.events.AreaEvent;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeAreaEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeAreaEvent.class);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Post e) {
        Level level = e.level();
        if (level.isClientSide()) {
            return;
        }
        AreaEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        AreaEvent.onNeighbourNotice(level, e.getPos(), e.getState(), e.getNotifiedSides(), e.getForceRedstoneUpdate());
    }
}

