/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_neoforge.events;

import com.natamus.areas_common_neoforge.config.ConfigHandler;
import com.natamus.areas_common_neoforge.data.AreaVariables;
import com.natamus.areas_common_neoforge.events.GUIEvent;
import com.natamus.areas_common_neoforge.objects.AreaObject;
import com.natamus.areas_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.functions.FABFunctions;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ClientEvent {
    public static void onClientTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        GUIEvent.tickHUDFade();
        if (player.tickCount % 20 != 0) {
            return;
        }
        for (AreaObject enteredAreaObject : AreaVariables.enteredAreas) {
            if (Util.getAreaSign(enteredAreaObject.level, enteredAreaObject.location) != null) continue;
            Util.removedArea(enteredAreaObject, (Player)player);
        }
        Level level = player.level();
        BlockPos ppos = player.blockPosition();
        ArrayList<AreaObject> allAreaObjects = new ArrayList<AreaObject>();
        for (BlockEntity nearbyBlockEntity : FABFunctions.getBlockEntitiesAroundPosition((Level)level, (BlockPos)player.blockPosition(), (Integer)ConfigHandler.radiusAroundPlayerToCheckForSigns)) {
            BlockPos nspos;
            AreaObject areaObject;
            BlockState blockEntityState = nearbyBlockEntity.getBlockState();
            if (!blockEntityState.is(BlockTags.ALL_SIGNS) && !blockEntityState.is(BlockTags.ALL_HANGING_SIGNS) || (areaObject = Util.getAreaSign(level, nspos = nearbyBlockEntity.getBlockPos())) == null) continue;
            allAreaObjects.add(areaObject);
        }
        for (AreaObject areaObject : allAreaObjects) {
            if (areaObject == null) continue;
            BlockPos nspos = areaObject.location;
            if (ppos.closerThan((Vec3i)nspos, (double)areaObject.radius)) {
                if (AreaVariables.enteredAreas.contains(areaObject)) continue;
                Util.enterArea(areaObject, (Player)player);
                continue;
            }
            if (!AreaVariables.enteredAreas.contains(areaObject)) continue;
            Util.exitArea(areaObject, (Player)player);
        }
    }
}

