/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes.box;

import com.builtbroken.cardboardboxes.Cardboardboxes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BoxBlockEntity
extends BlockEntity {
    private BlockState placementState;
    private Optional<CompoundTag> placementData = Optional.empty();

    public BoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Cardboardboxes.BOX_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        tag.getInt("storedTile").ifPresent(id -> {
            this.setStateForPlacement(Block.stateById((int)id));
            this.setDataForPlacement(tag.read("tileData", CompoundTag.CODEC));
        });
    }

    public void saveAdditional(ValueOutput tag) {
        if (this.getStateForPlacement() != null) {
            tag.putInt("storedTile", Block.getId((BlockState)this.placementState));
            this.getDataForPlacement().ifPresent(data -> {
                ValueOutput child = tag.child("tileData");
                child.store(data);
            });
        }
        super.saveAdditional(tag);
    }

    public BlockState getStateForPlacement() {
        return this.placementState;
    }

    public void setStateForPlacement(BlockState state) {
        this.placementState = state;
    }

    public Optional<CompoundTag> getDataForPlacement() {
        return this.placementData;
    }

    public void setDataForPlacement(Optional<CompoundTag> placementData) {
        this.placementData = placementData;
    }
}

