/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes.box;

import com.builtbroken.cardboardboxes.Cardboardboxes;
import com.builtbroken.cardboardboxes.box.BoxBlock;
import com.builtbroken.cardboardboxes.box.BoxBlockEntity;
import com.builtbroken.cardboardboxes.handler.CanPickUpResult;
import com.builtbroken.cardboardboxes.handler.Handler;
import com.builtbroken.cardboardboxes.handler.HandlerManager;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;

public class BoxBlockItem
extends BlockItem {
    public final DyeColor color;

    public BoxBlockItem(Block block, DyeColor color, Item.Properties properties) {
        super(block, properties);
        this.color = color;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        ItemStack heldItemStack = context.getItemInHand();
        if (!heldItemStack.isEmpty()) {
            BlockState storeBlock = this.getStoredBlock(heldItemStack);
            if (storeBlock.getBlock() != Blocks.AIR) {
                return this.tryToPlaceBlock(new BlockPlaceContext(context));
            }
            return this.tryToPickupBlock(player, level, context.getClickedPos(), hand, context.getClickedFace());
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult tryToPickupBlock(Player player, Level level, BlockPos pos, InteractionHand hand, Direction direction) {
        CanPickUpResult result = HandlerManager.INSTANCE.canPickUp(level, pos);
        if (result == CanPickUpResult.CAN_PICK_UP) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                BlockState state = level.getBlockState(pos);
                CompoundTag tag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                level.removeBlockEntity(pos);
                level.setBlock(pos, this.getBlock().defaultBlockState(), 2);
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof BoxBlockEntity) {
                    BoxBlockEntity boxBlockEntity = (BoxBlockEntity)blockEntity2;
                    boxBlockEntity.setStateForPlacement(state);
                    boxBlockEntity.setDataForPlacement(Optional.of(tag));
                    player.getItemInHand(hand).shrink(1);
                    return InteractionResult.SUCCESS;
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".noData")), true);
            }
        } else if (result == CanPickUpResult.BANNED_BLOCK_ENTITY) {
            player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".banned.tile")), true);
        } else if (result == CanPickUpResult.BANNED_BLOCK) {
            player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".banned.block")), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".noData")), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult tryToPlaceBlock(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        float hitX = (float)context.getClickLocation().x();
        float hitY = (float)context.getClickLocation().y();
        float hitZ = (float)context.getClickLocation().z();
        if (!context.canPlace()) {
            pos = pos.relative(context.getClickedFace());
        }
        ItemStack heldItemStack = context.getItemInHand();
        BlockState storedBlockState = this.getStoredBlock(heldItemStack);
        CompoundTag storedBlockEntityData = this.getStoredBlockEntityData(heldItemStack);
        if (storedBlockState != null && context.getPlayer().mayUseItemAt(pos, context.getClickedFace(), heldItemStack) && context.getLevel().getBlockState(pos).canBeReplaced()) {
            Handler handler = HandlerManager.INSTANCE.getHandler(storedBlockState.getBlock());
            BlockState blockstate = storedBlockState.getBlock().getStateForPlacement(context);
            if (handler != null && handler.placeBlock(context.getPlayer(), context.getLevel(), pos, hand, context.getClickedFace(), hitX, hitY, hitZ, storedBlockState, storedBlockEntityData) || this.placeBlock(context, blockstate)) {
                BlockEntity blockEntity;
                blockstate = context.getLevel().getBlockState(pos);
                if (handler != null) {
                    handler.postPlaceBlock(context.getPlayer(), context.getLevel(), pos, hand, context.getClickedFace(), hitX, hitY, hitZ, storedBlockState, storedBlockEntityData);
                }
                if (storedBlockEntityData != null && (blockEntity = context.getLevel().getBlockEntity(pos)) != null) {
                    try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Cardboardboxes.LOGGER);){
                        ValueInput valueInput = TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)context.getLevel().registryAccess(), (CompoundTag)storedBlockEntityData);
                        if (handler != null) {
                            handler.loadData(blockEntity, valueInput);
                        } else {
                            blockEntity.loadWithComponents(valueInput);
                        }
                    }
                }
                SoundType soundtype = blockstate.getBlock().getSoundType(blockstate, (LevelReader)context.getLevel(), pos, (Entity)context.getPlayer());
                context.getLevel().playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                heldItemStack.shrink(1);
                if (!context.getPlayer().isCreative()) {
                    context.getPlayer().getInventory().placeItemBackInInventory(new ItemStack((ItemLike)this.getBlock()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA) ? 1 : 64;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, TooltipDisplay display, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null && data.contains("storedItem")) {
            data.copyTag().getInt("storedItem").ifPresent(id -> {
                BlockState state = Block.stateById((int)id);
                tooltipAdder.accept((Component)Component.translatable((String)state.getBlock().getDescriptionId()));
            });
        }
    }

    public BlockState getStoredBlock(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return data != null ? data.copyTag().getInt("storedItem").map(Block::stateById).orElse(Blocks.AIR.defaultBlockState()) : Blocks.AIR.defaultBlockState();
    }

    public CompoundTag getStoredBlockEntityData(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return data != null ? (CompoundTag)data.copyTag().getCompound("tileData").orElse(null) : null;
    }
}

