/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes.handler;

import com.builtbroken.cardboardboxes.handler.CanPickUpResult;
import com.builtbroken.cardboardboxes.handler.Handler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class HandlerManager {
    public static final HandlerManager INSTANCE = new HandlerManager();
    public static HashMap<Class<? extends BlockEntity>, Handler> pickupHandlerMap = new HashMap();
    public static HashMap<Block, Handler> handlerMap = new HashMap();
    public static List<BlockEntityType<?>> blockEntityBanList = new ArrayList();
    public static List<Block> blockBanList = new ArrayList<Block>();

    public void registerPickupHandler(Class<? extends BlockEntity> clazz, Handler handler) {
        pickupHandlerMap.put(clazz, handler);
    }

    public void registerHandler(Block block, Handler handler) {
        handlerMap.put(block, handler);
    }

    public Handler getHandler(Block block) {
        return handlerMap.get(block);
    }

    public void banBlockEntity(BlockEntityType<?> tile) {
        if (!blockEntityBanList.contains(tile)) {
            blockEntityBanList.add(tile);
        }
    }

    public void banBlock(Block block) {
        if (!blockBanList.contains(block)) {
            blockBanList.add(block);
        }
    }

    public CanPickUpResult canPickUp(Level world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (!blockBanList.contains(block)) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity != null) {
                if (!blockEntityBanList.contains(blockEntity.getType())) {
                    return !blockEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess()).isEmpty() ? CanPickUpResult.CAN_PICK_UP : CanPickUpResult.NO_DATA;
                }
                return CanPickUpResult.BANNED_BLOCK_ENTITY;
            }
            return CanPickUpResult.NO_BLOCK_ENTITY;
        }
        return CanPickUpResult.BANNED_BLOCK;
    }
}

