/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes.mods;

import com.builtbroken.cardboardboxes.Cardboardboxes;
import com.builtbroken.cardboardboxes.handler.HandlerManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModHandler {
    public static HashMap<String, Class<? extends ModHandler>> modSupportHandlerMap = new HashMap();
    public static HashMap<String, ModHandler> modSupportHandlerMap_instances = new HashMap();
    protected static Registry<BlockEntityType<?>> BLOCK_ENTITIES_REGISTRY;
    public static HashMap<String, ModConfigSpec.BooleanValue> blockEntityBanConfigMap;

    public void load(ModConfigSpec configuration) {
    }

    public void build(ModConfigSpec.Builder b) {
    }

    public static ModConfigSpec buildHandlerData() {
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        Cardboardboxes.LOGGER.info("ModHandler#buildHandlerData() -> Loading data and data handlers");
        ModHandler.loadBlockEntityRegistry();
        ModHandler.buildHandlers(b);
        ModHandler.buildConfig(b);
        return b.build();
    }

    public static void loadHandlerData(ModConfigSpec configuration) {
        Cardboardboxes.LOGGER.info("ModHandler#loadHandlerData() -> Accessed Block Entity Registry: " + (BLOCK_ENTITIES_REGISTRY != null));
        ModHandler.processHandlers(configuration);
        Cardboardboxes.LOGGER.info("ModHandler#loadHandlerData() -> Finished loading data handlers");
        ModHandler.loadConfig(configuration);
        Cardboardboxes.LOGGER.info("ModHandler#loadHandlerData() -> Finished loading configurations");
    }

    private static void buildHandlers(ModConfigSpec.Builder b) {
        for (Map.Entry<String, Class<? extends ModHandler>> entry : modSupportHandlerMap.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey()) && !entry.getKey().equals("minecraft")) continue;
            try {
                ModHandler instance = entry.getValue().newInstance();
                modSupportHandlerMap_instances.put(entry.getKey(), instance);
                instance.build(b);
            }
            catch (InstantiationException e) {
                Cardboardboxes.LOGGER.error("Failed to create handler for mod " + entry.getKey());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Cardboardboxes.LOGGER.error("Failed to access constructor for handler for mod " + entry.getKey());
                e.printStackTrace();
            }
        }
    }

    private static void processHandlers(ModConfigSpec configuration) {
        for (Map.Entry<String, ModHandler> entry : modSupportHandlerMap_instances.entrySet()) {
            entry.getValue().load(configuration);
        }
    }

    public static void buildConfig(ModConfigSpec.Builder b) {
        String comment = "Auto generated list of block entities registered in Minecraft that can be blocked from use with the box. If a block entity does not show up on this list it is already black listed. The reasoning behind blocking block entities is to prevent crashes or unwanted interaction. Such as picking up a piston which can both causes issues and doesn't really matter. Set value to 'true' to disable interaction.";
        b.comment(comment).push("tile_ban_list");
        for (Identifier name : BLOCK_ENTITIES_REGISTRY.keySet()) {
            BLOCK_ENTITIES_REGISTRY.get(name).ifPresent(ref -> {
                BlockEntityType type = (BlockEntityType)ref.getDelegate().value();
                if (name != null && type != null) {
                    try {
                        String typeString = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)type).toString();
                        boolean shouldBan = HandlerManager.blockEntityBanList.contains(type) || typeString.contains("cable") || typeString.contains("wire") || typeString.contains("pipe") || typeString.contains("tube") || typeString.contains("conduit") || typeString.contains("channel");
                        blockEntityBanConfigMap.put(typeString, b.define(typeString, shouldBan));
                    }
                    catch (Exception e) {
                        Cardboardboxes.LOGGER.error("ModHandler#buildConfig() -> Failed to add entry to config [" + String.valueOf(name) + " > " + String.valueOf(type) + "]", (Throwable)e);
                    }
                }
            });
        }
        b.pop();
    }

    private static void loadConfig(ModConfigSpec configuration) {
        if (BLOCK_ENTITIES_REGISTRY != null) {
            for (Identifier name : BLOCK_ENTITIES_REGISTRY.keySet()) {
                BLOCK_ENTITIES_REGISTRY.get(name).ifPresent(ref -> {
                    BlockEntityType type = (BlockEntityType)ref.getDelegate().value();
                    if (name != null && type != null) {
                        try {
                            boolean shouldBan;
                            String typeString = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)type).toString();
                            boolean bl = shouldBan = HandlerManager.blockEntityBanList.contains(type) || typeString.contains("cable") || typeString.contains("wire") || typeString.contains("pipe") || typeString.contains("tube") || typeString.contains("conduit") || typeString.contains("channel");
                            if (blockEntityBanConfigMap.containsKey(typeString) && ((Boolean)blockEntityBanConfigMap.get(typeString).get()).booleanValue()) {
                                HandlerManager.INSTANCE.banBlockEntity(type);
                            } else if (shouldBan) {
                                HandlerManager.blockEntityBanList.remove(type);
                            }
                        }
                        catch (Exception e) {
                            Cardboardboxes.LOGGER.error("ModHandler#loadHandlerData() -> Failed to add entry to config [" + String.valueOf(name) + " > " + String.valueOf(type) + "]", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    private static void loadBlockEntityRegistry() {
        BLOCK_ENTITIES_REGISTRY = BuiltInRegistries.BLOCK_ENTITY_TYPE;
    }

    static {
        blockEntityBanConfigMap = new HashMap();
    }
}

