/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging.f3;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class F3Screen {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();

    public static void addStringToDisplay(List<String> messageList) {
        PriorityTaskPicker.Executor worldGenPool = ThreadPoolUtil.getWorldGenExecutor();
        PriorityTaskPicker.Executor fileHandlerPool = ThreadPoolUtil.getFileHandlerExecutor();
        PriorityTaskPicker.Executor renderLoadingPool = ThreadPoolUtil.getRenderLoadingExecutor();
        PriorityTaskPicker.Executor updatePool = ThreadPoolUtil.getUpdatePropagatorExecutor();
        PriorityTaskPicker.Executor lodBuilderPool = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        PriorityTaskPicker.Executor networkPool = ThreadPoolUtil.getNetworkCompressionExecutor();
        ThreadPoolExecutor cleanupPool = ThreadPoolUtil.getCleanupExecutor();
        ThreadPoolExecutor beaconCullingPool = ThreadPoolUtil.getBeaconCullingExecutor();
        ThreadPoolExecutor migrationPool = ThreadPoolUtil.getFullDataMigrationExecutor();
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            return;
        }
        Iterable<? extends IDhLevel> levelIterator = world.getAllLoadedLevels();
        messageList.add("");
        messageList.add("Distant Horizons: 2.4.5-b");
        if (ModInfo.IS_DEV_BUILD) {
            messageList.add("Build: " + StringUtil.shortenString(ModJarInfo.Git_Commit, 8) + " (" + ModJarInfo.Git_Branch + ")");
        }
        if (ClientApi.INSTANCE.lastRenderParamValidationMessage != null) {
            messageList.add("Render Validation Err: " + ClientApi.INSTANCE.lastRenderParamValidationMessage);
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showPlayerPos.get().booleanValue()) {
            if (MC_CLIENT != null) {
                byte requestedDetailLevel = Config.Client.Advanced.Debugging.F3Screen.playerPosSectionDetailLevel.get().byteValue();
                long l = DhSectionPos.encodeContaining(requestedDetailLevel, MC_CLIENT.getPlayerChunkPos());
                byte detailLevel = DhSectionPos.getDetailLevel(l);
                int posX = DhSectionPos.getX(l);
                int posZ = DhSectionPos.getZ(l);
                messageList.add("LOD Pos: " + detailLevel + "*" + posX + "," + posZ);
            }
            messageList.add("");
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showThreadPools.get().booleanValue()) {
            messageList.add(F3Screen.getThreadPoolStatString("World Gen/Import", worldGenPool));
            messageList.add(F3Screen.getThreadPoolStatString("Render Load", renderLoadingPool));
            messageList.add(F3Screen.getThreadPoolStatString("File Handler", fileHandlerPool));
            messageList.add(F3Screen.getThreadPoolStatString("Update Propagator", updatePool));
            messageList.add(F3Screen.getThreadPoolStatString("LOD Builder", lodBuilderPool));
            messageList.add(F3Screen.getThreadPoolStatString("Networking", networkPool));
            messageList.add("");
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showCombinedObjectPools.get().booleanValue()) {
            PhantomArrayListPool.addDebugMenuStringsToListForCombinedPools(messageList);
            messageList.add("");
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showSeparatedObjectPools.get().booleanValue()) {
            PhantomArrayListPool.addDebugMenuStringsToListForSeparatePools(messageList);
            messageList.add("");
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showQueuedChunkUpdateCount.get().booleanValue()) {
            messageList.add(SharedApi.INSTANCE.getDebugMenuString());
            messageList.add("");
        }
        if (Config.Client.Advanced.Debugging.F3Screen.showLevelStatus.get().booleanValue()) {
            world.addDebugMenuStringsToList(messageList);
            messageList.add("");
            for (IDhLevel iDhLevel : levelIterator) {
                GenericObjectRenderer genericRenderer;
                iDhLevel.addDebugMenuStringsToList(messageList);
                RenderBufferHandler renderBufferHandler = iDhLevel.getRenderBufferHandler();
                if (renderBufferHandler != null) {
                    messageList.add(renderBufferHandler.getVboRenderDebugMenuString());
                    String showPassString = renderBufferHandler.getShadowPassRenderDebugMenuString();
                    if (showPassString != null) {
                        messageList.add(showPassString);
                    }
                }
                if ((genericRenderer = iDhLevel.getGenericRenderer()) != null) {
                    messageList.add(genericRenderer.getVboRenderDebugMenuString());
                }
                messageList.add("");
            }
        }
    }

    private static String getThreadPoolStatString(String name, PriorityTaskPicker.Executor pool) {
        String queueSize = pool != null ? NUMBER_FORMAT.format(pool.getQueueSize()) : "-";
        String completedCount = pool != null ? NUMBER_FORMAT.format(pool.getCompletedTaskCount()) : "-";
        String message = name + ", Tasks: " + queueSize + ", Done: " + completedCount;
        if (pool != null) {
            int activeThreadCount = pool.getRunningTaskCount();
            int threadCount = pool.getPoolSize();
            message = message + ", Active: " + activeThreadCount + "/" + threadCount;
            double runTimeAvgInMs = pool.getAverageRunTimeInMs();
            String runTimeAvgStr = !Double.isNaN(runTimeAvgInMs) ? NUMBER_FORMAT.format(runTimeAvgInMs) : "<0";
            message = message + ", Avg: " + runTimeAvgStr + "ms";
        }
        return message;
    }
}

