/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import org.lwjgl.opengl.GL32;

public class SSAOShader
extends AbstractShaderRenderer {
    public static SSAOShader INSTANCE = new SSAOShader();
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public int frameBuffer;
    private Mat4f projection;
    private Mat4f invertedProjection;
    public int uProj;
    public int uInvProj;
    public int uSampleCount;
    public int uRadius;
    public int uStrength;
    public int uMinLight;
    public int uBias;
    public int uDepthMap;
    public int uFadeDistanceInBlocks;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/ssao/ao.frag", "fragColor", new String[]{"vPosition"});
        this.uProj = this.shader.getUniformLocation("uProj");
        this.uInvProj = this.shader.getUniformLocation("uInvProj");
        this.uSampleCount = this.shader.getUniformLocation("uSampleCount");
        this.uRadius = this.shader.getUniformLocation("uRadius");
        this.uStrength = this.shader.getUniformLocation("uStrength");
        this.uMinLight = this.shader.getUniformLocation("uMinLight");
        this.uBias = this.shader.getUniformLocation("uBias");
        this.uDepthMap = this.shader.getUniformLocation("uDepthMap");
        this.uFadeDistanceInBlocks = this.shader.getUniformLocation("uFadeDistanceInBlocks");
    }

    public void setProjectionMatrix(Mat4f projectionMatrix) {
        this.projection = projectionMatrix;
        this.invertedProjection = new Mat4f(projectionMatrix);
        this.invertedProjection.invert();
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        this.shader.setUniform(this.uProj, this.projection);
        this.shader.setUniform(this.uInvProj, this.invertedProjection);
        this.shader.setUniform(this.uSampleCount, Config.Client.Advanced.Graphics.Ssao.sampleCount.get());
        Number radius = Config.Client.Advanced.Graphics.Ssao.radius.get();
        this.shader.setUniform(this.uRadius, radius.floatValue());
        Number strength = Config.Client.Advanced.Graphics.Ssao.strength.get();
        this.shader.setUniform(this.uStrength, strength.floatValue());
        Number minLight = Config.Client.Advanced.Graphics.Ssao.minLight.get();
        this.shader.setUniform(this.uMinLight, minLight.floatValue());
        Number bias = Config.Client.Advanced.Graphics.Ssao.bias.get();
        this.shader.setUniform(this.uBias, bias.floatValue());
        GL32.glUniform1i((int)this.uDepthMap, (int)0);
        float fadeDistanceInBlocks = Config.Client.Advanced.Graphics.Ssao.fadeDistanceInBlocks.get().floatValue();
        fadeDistanceInBlocks = MathUtil.clamp(0.0f, fadeDistanceInBlocks, Float.MAX_VALUE);
        this.shader.setUniform(this.uFadeDistanceInBlocks, fadeDistanceInBlocks);
    }

    @Override
    protected void onRender() {
        GLMC.glBindFramebuffer(36160, this.frameBuffer);
        GLMC.disableScissorTest();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(LodRenderer.INSTANCE.getActiveDepthTextureId());
        ScreenQuad.INSTANCE.render();
    }
}

