/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV1DTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV1Repo
extends AbstractDhRepo<Long, FullDataSourceV1DTO> {
    public static final String TABLE_NAME = "Legacy_FullData_V1";
    private final String insertSqlTemplate = "INSERT INTO " + this.getTableName() + "\n  (DhSectionPos, \nChecksum, DataVersion, DataDetailLevel, WorldGenStep, DataType, BinaryDataFormatVersion, \nData) \n   VALUES( \n    ? \n   ,? ,? ,? ,? ,? ,? \n   ,? \n);";
    private final String updateSqlTemplate = "UPDATE " + this.getTableName() + " \nSET \n    Checksum = ? \n   ,DataVersion = ? \n   ,DataDetailLevel = ? \n   ,WorldGenStep = ? \n   ,DataType = ? \n   ,BinaryDataFormatVersion = ? \n   ,Data = ? \n   ,LastModifiedDateTime = CURRENT_TIMESTAMP \nWHERE DhSectionPos = ?";
    private final String getMigrationPositionsSqlTemplate = "SELECT DhSectionPos FROM " + this.getTableName() + " WHERE MigrationFailed <> 1 LIMIT ?;";
    private final String getUnusedPositionSqlTemplate = "SELECT DhSectionPos FROM " + this.getTableName() + " WHERE DataDetailLevel <> 0 OR DataType <> 'CompleteFullDataSource' LIMIT ?";

    public FullDataSourceV1Repo(String databaseType, File databaseFile) throws SQLException, IOException {
        super(databaseType, databaseFile, FullDataSourceV1DTO.class);
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    protected String CreateParameterizedWhereString() {
        return "DhSectionPos = ?";
    }

    @Override
    protected int setPreparedStatementWhereClause(PreparedStatement statement, int index, Long pos) throws SQLException {
        statement.setString(index++, FullDataSourceV1Repo.serializeSectionPos(pos));
        return index;
    }

    @Override
    @Nullable
    public FullDataSourceV1DTO convertResultSetToDto(ResultSet resultSet) throws ClassCastException, SQLException {
        String posString = resultSet.getString("DhSectionPos");
        Long pos = FullDataSourceV1Repo.deserializeSectionPos(posString);
        int checksum = resultSet.getInt("Checksum");
        byte dataDetailLevel = resultSet.getByte("DataDetailLevel");
        String worldGenStepString = resultSet.getString("WorldGenStep");
        EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.fromName(worldGenStepString);
        String dataType = resultSet.getString("DataType");
        byte binaryDataFormatVersion = resultSet.getByte("BinaryDataFormatVersion");
        byte[] dataByteArray = resultSet.getBytes("Data");
        FullDataSourceV1DTO dto = new FullDataSourceV1DTO(pos, checksum, dataDetailLevel, worldGenStep, dataType, binaryDataFormatVersion, dataByteArray);
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(FullDataSourceV1DTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.insertSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setString(i++, FullDataSourceV1Repo.serializeSectionPos(dto.pos));
        statement.setInt(i++, dto.checksum);
        statement.setInt(i++, 0);
        statement.setByte(i++, dto.dataDetailLevel);
        statement.setObject(i++, (Object)dto.worldGenStep);
        statement.setString(i++, dto.dataType);
        statement.setByte(i++, dto.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(FullDataSourceV1DTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.updateSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setInt(i++, dto.checksum);
        statement.setInt(i++, 0);
        statement.setByte(i++, dto.dataDetailLevel);
        statement.setObject(i++, (Object)dto.worldGenStep);
        statement.setString(i++, dto.dataType);
        statement.setByte(i++, dto.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        statement.setString(i++, FullDataSourceV1Repo.serializeSectionPos(dto.pos));
        return statement;
    }

    public long getMigrationCount() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select COUNT(*) as itemCount from " + this.getTableName() + " where MigrationFailed <> 1");
        if (resultMap == null) {
            return 0L;
        }
        Number resultNumber = (Number)resultMap.get("itemCount");
        long count = resultNumber.longValue();
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LongArrayList getPositionsToMigrate(int returnCount) {
        LongArrayList posList = new LongArrayList();
        try (PreparedStatement statement = this.createPreparedStatement(this.getMigrationPositionsSqlTemplate);){
            if (statement == null) {
                LongArrayList longArrayList = posList;
                return longArrayList;
            }
            int i = 1;
            statement.setInt(i++, returnCount);
            try (ResultSet result = this.query(statement);){
                while (result != null) {
                    if (!result.next()) return posList;
                    String posString = result.getString("DhSectionPos");
                    Long sectionPos = FullDataSourceV1Repo.deserializeSectionPos(posString);
                    if (sectionPos == null) continue;
                    posList.add(sectionPos.longValue());
                }
                return posList;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void markMigrationFailed(long pos) {
        String sql = "UPDATE " + this.getTableName() + " \nSET MigrationFailed = 1 \nWHERE DhSectionPos = '" + FullDataSourceV1Repo.serializeSectionPos(pos) + "'";
        this.queryDictionaryFirst(sql);
    }

    public long getUnusedDataSourceCount() {
        Map<String, Object> resultMap = this.queryDictionaryFirst("select Count(*) as unusedCount from " + this.getTableName() + " where DataDetailLevel <> 0 or DataType <> 'CompleteFullDataSource'");
        if (resultMap != null) {
            Number resultNumber = (Number)resultMap.get("unusedCount");
            long count = resultNumber.longValue();
            return count;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> getUnusedDataSourcePositionStringList(int limit) {
        ArrayList<String> deletePosList = new ArrayList<String>();
        try (PreparedStatement statement = this.createPreparedStatement(this.getUnusedPositionSqlTemplate);){
            if (statement == null) {
                ArrayList<String> arrayList = deletePosList;
                return arrayList;
            }
            int i = 1;
            statement.setInt(i++, limit);
            try (ResultSet result = this.query(statement);){
                while (result != null) {
                    if (!result.next()) return deletePosList;
                    String posString = result.getString("DhSectionPos");
                    deletePosList.add("'" + posString + "'");
                }
                return deletePosList;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteUnusedLegacyData(ArrayList<String> deletePosList) {
        String sectionPosCsv = StringUtil.join(",", deletePosList);
        this.queryDictionaryFirst("delete from " + this.getTableName() + " where DhSectionPos in (" + sectionPosCsv + ")");
    }

    private static String serializeSectionPos(long pos) {
        return "[" + DhSectionPos.getDetailLevel(pos) + ',' + DhSectionPos.getX(pos) + ',' + DhSectionPos.getZ(pos) + ']';
    }

    @Nullable
    private static Long deserializeSectionPos(String value) {
        if (value.charAt(0) != '[' || value.charAt(value.length() - 1) != ']') {
            return null;
        }
        String[] split = value.substring(1, value.length() - 1).split(",");
        if (split.length != 3) {
            return null;
        }
        return DhSectionPos.encode(Byte.parseByte(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

