/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.rangecoder;

import java.io.IOException;
import org.tukaani.xz.rangecoder.RangeCoder;

public abstract class RangeEncoder
extends RangeCoder {
    private static final int MOVE_REDUCING_BITS = 4;
    private static final int BIT_PRICE_SHIFT_BITS = 4;
    private static final int[] prices = new int[128];
    private long low;
    private int range;
    long cacheSize;
    private byte cache;

    public void reset() {
        this.low = 0L;
        this.range = -1;
        this.cache = 0;
        this.cacheSize = 1L;
    }

    public int getPendingSize() {
        throw new Error();
    }

    public int finish() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.shiftLow();
        }
        return -1;
    }

    abstract void writeByte(int var1) throws IOException;

    private void shiftLow() throws IOException {
        int n = (int)(this.low >>> 32);
        if (n != 0 || this.low < 0xFF000000L) {
            int n2 = this.cache;
            do {
                this.writeByte(n2 + n);
                n2 = 255;
            } while (--this.cacheSize != 0L);
            this.cache = (byte)(this.low >>> 24);
        }
        ++this.cacheSize;
        this.low = (this.low & 0xFFFFFFL) << 8;
    }

    public void encodeBit(short[] ss, int i, int j) throws IOException {
        short s = ss[i];
        int n = (this.range >>> 11) * s;
        if (j == 0) {
            this.range = n;
            ss[i] = (short)(s + (2048 - s >>> 5));
        } else {
            this.low += (long)n & 0xFFFFFFFFL;
            this.range -= n;
            ss[i] = (short)(s - (s >>> 5));
        }
        if ((this.range & 0xFF000000) == 0) {
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public static int getBitPrice(int i, int j) {
        assert (j == 0 || j == 1);
        return prices[(i ^ -j & 0x7FF) >>> 4];
    }

    public void encodeBitTree(short[] ss, int i) throws IOException {
        int n = 1;
        int n2 = ss.length;
        do {
            int n3 = i & (n2 >>>= 1);
            this.encodeBit(ss, n, n3);
            n <<= 1;
            if (n3 == 0) continue;
            n |= 1;
        } while (n2 != 1);
    }

    public static int getBitTreePrice(short[] ss, int i) {
        int n = 0;
        i |= ss.length;
        do {
            int n2 = i & 1;
            n += RangeEncoder.getBitPrice(ss[i >>>= 1], n2);
        } while (i != 1);
        return n;
    }

    public void encodeReverseBitTree(short[] ss, int i) throws IOException {
        int n = 1;
        i |= ss.length;
        do {
            int n2 = i & 1;
            this.encodeBit(ss, n, n2);
            n = n << 1 | n2;
        } while ((i >>>= 1) != 1);
    }

    public static int getReverseBitTreePrice(short[] ss, int i) {
        int n = 0;
        int n2 = 1;
        i |= ss.length;
        do {
            int n3 = i & 1;
            n += RangeEncoder.getBitPrice(ss[n2], n3);
            n2 = n2 << 1 | n3;
        } while ((i >>>= 1) != 1);
        return n;
    }

    public void encodeDirectBits(int i, int j) throws IOException {
        do {
            this.range >>>= 1;
            this.low += (long)(this.range & 0 - (i >>> --j & 1));
            if ((this.range & 0xFF000000) != 0) continue;
            this.range <<= 8;
            this.shiftLow();
        } while (j != 0);
    }

    public static int getDirectBitsPrice(int i) {
        return i << 4;
    }

    static {
        for (int i = 8; i < 2048; i += 16) {
            int n = i;
            int n2 = 0;
            for (int j = 0; j < 4; ++j) {
                n *= n;
                n2 <<= 1;
                while ((n & 0xFFFF0000) != 0) {
                    n >>>= 1;
                    ++n2;
                }
            }
            RangeEncoder.prices[i >> 4] = 161 - n2;
        }
    }
}

