/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.codec.CodecUtils;
import de.maxhenkel.gravestone.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GraveStoneTileEntity
extends BlockEntity
implements Nameable {
    protected Death death = new Death.Builder(GraveUtils.EMPTY_UUID, GraveUtils.EMPTY_UUID).build();
    @Nullable
    protected Component customName;

    public GraveStoneTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GravestoneMod.GRAVESTONE_TILEENTITY.get(), pos, state);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.death.write(valueOutput, "Death");
        if (this.customName != null) {
            CompoundTag tag = new CompoundTag();
            CodecUtils.toJsonString(ComponentSerialization.CODEC, this.customName).ifPresent(s -> tag.putString("CustomName", s));
            valueOutput.store(tag);
        }
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.death = Death.read(valueInput, "Death");
        Optional optionalName = valueInput.getString("CustomName");
        optionalName.ifPresent(s -> {
            this.customName = CodecUtils.fromJson(ComponentSerialization.CODEC, s).orElse(null);
        });
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput(this, provider);
        this.saveAdditional((ValueOutput)valueOutput);
        return ValueInputOutputUtils.toTag(valueOutput);
    }

    public Death getDeath() {
        return this.death;
    }

    public void setDeath(Death death) {
        this.death = death;
        this.setChanged();
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.setChanged();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    protected Component getDefaultName() {
        String name = this.death.getPlayerName();
        if (name == null || name.isEmpty()) {
            return Component.translatable((String)((GraveStoneBlock)((Object)GravestoneMod.GRAVESTONE.get())).getDescriptionId());
        }
        return Component.translatable((String)"message.gravestone.grave_of", (Object[])new Object[]{name});
    }

    @Nullable
    public Component getGraveName() {
        if (!this.death.getPlayerName().isEmpty()) {
            return Component.literal((String)this.death.getPlayerName());
        }
        if (this.customName != null) {
            return this.customName;
        }
        return null;
    }
}

