/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.littlejoys.LittleJoysConfig;
import net.blay09.mods.littlejoys.handler.GoldRushInstance;
import net.blay09.mods.littlejoys.mixin.RecipeManagerAccessor;
import net.blay09.mods.littlejoys.network.protocol.ClientboundGoldRushPacket;
import net.blay09.mods.littlejoys.recipe.GoldRushRecipe;
import net.blay09.mods.littlejoys.recipe.ModRecipeTypes;
import net.blay09.mods.littlejoys.recipe.condition.EventContextImpl;
import net.blay09.mods.littlejoys.stats.ModStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GoldRushHandler {
    private static final RandomSource random = RandomSource.create();
    private static final Table<ResourceKey<Level>, BlockPos, GoldRushInstance> activeGoldRushes = HashBasedTable.create();

    public static void initialize() {
        BlockCallback.Break.Before.EVENT.register((level, pos, state, blockEntity, player) -> {
            ServerLevel serverLevel;
            block11: {
                block10: {
                    if (player.getAbilities().instabuild) {
                        return true;
                    }
                    if (Balm.hooks().isFakePlayer(player)) {
                        return true;
                    }
                    Boolean hasSilkTouch = level.registryAccess().lookup(Registries.ENCHANTMENT).flatMap(it -> it.get(Enchantments.SILK_TOUCH)).map(it -> EnchantmentHelper.getEnchantmentLevel((Holder)it, (LivingEntity)player) > 0).orElse(false);
                    if (hasSilkTouch.booleanValue()) {
                        return true;
                    }
                    if (!(level instanceof ServerLevel)) break block10;
                    serverLevel = (ServerLevel)level;
                    if (player instanceof ServerPlayer) break block11;
                }
                return true;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GoldRushInstance activeGoldRush = (GoldRushInstance)activeGoldRushes.get((Object)serverLevel.dimension(), (Object)pos);
            if (activeGoldRush == null) {
                activeGoldRush = GoldRushHandler.rollForGoldRush(serverLevel, pos, state, serverPlayer).orElse(null);
            }
            if (activeGoldRush != null) {
                if (activeGoldRush.getDropCooldownTicks() <= 0) {
                    BlockPos goldRushPos = activeGoldRush.getPos();
                    LootParams.Builder lootParamsBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)goldRushPos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(goldRushPos));
                    Optional<ResourceKey<LootTable>> lootTableId = activeGoldRush.getLootTable();
                    if (lootTableId.isPresent()) {
                        LootParams lootParams = lootParamsBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(goldRushPos)).create(LootContextParamSets.BLOCK);
                        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId.get());
                        lootTable.getRandomItems(lootParams).forEach(itemStack -> Block.popResource((Level)serverLevel, (BlockPos)goldRushPos, (ItemStack)itemStack));
                    }
                    activeGoldRush.setDropCooldownTicks(activeGoldRush.getTicksPerDrop());
                }
                return false;
            }
            return true;
        });
        ServerTickCallback.ServerLevelTick.BEFORE.register(level -> {
            for (GoldRushInstance goldRush : activeGoldRushes.row((Object)level.dimension()).values()) {
                goldRush.setTicksPassed(goldRush.getTicksPassed() + 1);
                goldRush.setDropCooldownTicks(goldRush.getDropCooldownTicks() - 1);
                if (goldRush.getTicksPassed() < goldRush.getMaxTicks()) continue;
                if (level.getBlockState(goldRush.getPos()).equals((Object)goldRush.getInitialState())) {
                    level.destroyBlock(goldRush.getPos(), true, (Entity)goldRush.getPlayer());
                }
                Balm.networking().sendToAll(level.getServer(), (CustomPacketPayload)new ClientboundGoldRushPacket(goldRush.getPos(), false));
            }
            activeGoldRushes.values().removeIf(it -> it.getTicksPassed() >= it.getMaxTicks());
        });
    }

    public static Optional<GoldRushInstance> rollForGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, false).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, (RecipeHolder<GoldRushRecipe>)recipe));
    }

    public static boolean isInGoldRush(ServerLevel level, BlockPos pos) {
        return activeGoldRushes.contains((Object)level.dimension(), (Object)pos);
    }

    public static Optional<GoldRushInstance> startGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        return GoldRushHandler.rollRecipe(level, pos, state, player, true).map(recipe -> GoldRushHandler.startGoldRush(level, pos, state, player, (RecipeHolder<GoldRushRecipe>)recipe));
    }

    public static GoldRushInstance startGoldRush(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, RecipeHolder<GoldRushRecipe> recipeHolder) {
        GoldRushRecipe recipe = (GoldRushRecipe)recipeHolder.value();
        GoldRushInstance activeGoldRush = new GoldRushInstance(pos, state, Optional.of(recipe.lootTable()), (int)Math.floor(20.0f * recipe.seconds()), recipe.maxDropsPerSecond() == -1.0f ? 0 : (int)Math.floor(20.0f / recipe.maxDropsPerSecond()), (Player)player);
        Balm.networking().sendToTracking(level, pos, (CustomPacketPayload)new ClientboundGoldRushPacket(pos, true));
        player.awardStat(ModStats.goldRushesTriggered);
        activeGoldRushes.put((Object)level.dimension(), (Object)pos, (Object)activeGoldRush);
        return activeGoldRush;
    }

    private static Optional<RecipeHolder<GoldRushRecipe>> rollRecipe(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, boolean force) {
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.goldRush.type());
        ArrayList<RecipeHolder> candidates = new ArrayList<RecipeHolder>();
        float baseChance = LittleJoysConfig.getActive().goldRush.baseChance;
        float roll = random.nextFloat();
        for (RecipeHolder recipeHolder : recipes) {
            if (!GoldRushHandler.isValidRecipeFor((RecipeHolder<GoldRushRecipe>)recipeHolder, level, pos, state, player) || !force && !(roll <= baseChance * ((GoldRushRecipe)recipeHolder.value()).chanceMultiplier())) continue;
            candidates.add(recipeHolder);
        }
        return WeightedRandom.getRandomItem((RandomSource)random, candidates, it -> ((GoldRushRecipe)it.value()).weight());
    }

    private static boolean isValidRecipeFor(RecipeHolder<GoldRushRecipe> recipe, ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player) {
        EventContextImpl context = new EventContextImpl((Level)level, pos, state, (Player)player);
        return ((GoldRushRecipe)recipe.value()).eventCondition().test(context);
    }
}

