/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.mineralchance_common_forge.events;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.fakeplayer.FakePlayer;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.mineralchance_common_forge.config.ConfigHandler;
import com.natamus.mineralchance_common_forge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MiningEvent {
    public static void onBlockBreak(Level level, Player player, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        Item randomMineralItem;
        if (level.isClientSide()) {
            return;
        }
        if (ConfigHandler.ignoreFakePlayers && player instanceof FakePlayer) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!Services.TOOLFUNCTIONS.isPickaxe(handStack)) {
            return;
        }
        if (ConfigHandler.disableMineralDropsWithSilkTouch && EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)handStack) >= 1) {
            return;
        }
        Block block = blockState.getBlock();
        if (!CompareBlockFunctions.isStoneBlock((Block)block) && !CompareBlockFunctions.isNetherStoneBlock((Block)block)) {
            return;
        }
        if (WorldFunctions.isOverworld((Level)level)) {
            if (!ConfigHandler.enableOverworldMinerals) {
                return;
            }
            if (CompareBlockFunctions.isNetherStoneBlock((Block)block)) {
                return;
            }
            if (GlobalVariables.random.nextDouble() > ConfigHandler.extraMineralChanceOnOverworldStoneBreak) {
                return;
            }
            randomMineralItem = Util.getRandomOverworldMineral();
        } else if (WorldFunctions.isNether((Level)level)) {
            if (!ConfigHandler.enableNetherMinerals) {
                return;
            }
            if (!CompareBlockFunctions.isNetherStoneBlock((Block)block)) {
                return;
            }
            if (GlobalVariables.random.nextDouble() > ConfigHandler.extraMineralChanceOnNetherStoneBreak) {
                return;
            }
            randomMineralItem = Util.getRandomNetherMineral();
        } else {
            return;
        }
        ItemEntity mineralItemEntity = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)randomMineralItem, 1));
        level.addFreshEntity((Entity)mineralItemEntity);
        if (ConfigHandler.sendMessageOnMineralFind && ((ServerPlayer)player).connection != null) {
            MessageFunctions.sendMessage((Player)player, (String)ConfigHandler.foundMineralMessage, (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
    }
}

