/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config.screen;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.quiltmc.config.api.Config;
import org.quiltmc.config.api.Configs;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueTreeNode;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.config.metadata.WidgetSize;
import page.langeweile.ok_zoomer.config.screen.ConfigTextUtils;
import page.langeweile.ok_zoomer.config.screen.ZoomPresets;
import page.langeweile.ok_zoomer.config.screen.components.LabelledEditBox;
import page.langeweile.ok_zoomer.config.screen.components.OkZoomerSelectionList;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.utils.ZoomUtils;

public class OkZoomerConfigScreen
extends Screen {
    private final Identifier configId;
    private final Screen parent;
    private ConfigTextUtils configTextUtils;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private OkZoomerSelectionList selectionList;
    private final Map<TrackedValue<Object>, Object> newValues;
    private final Set<TrackedValue<Object>> invalidValues;
    private AbstractWidget buttonBuffer = null;

    public OkZoomerConfigScreen(Screen parent) {
        super(ConfigTextUtils.getConfigTitle(ModUtils.id("config")));
        this.configId = ModUtils.id("config");
        this.parent = parent;
        this.newValues = new Reference2ObjectArrayMap();
        this.invalidValues = new ObjectArraySet();
    }

    protected void init() {
        Config config = Configs.getConfig((String)this.configId.getNamespace(), (String)this.configId.getPath());
        this.configTextUtils = new ConfigTextUtils(config);
        this.selectionList = new OkZoomerSelectionList(this.minecraft, this.width, this.height - 64, 32, this);
        this.selectionList.addCategory((Component)Component.translatable((String)"config.ok_zoomer.presets"));
        CycleButton presetButton = CycleButton.builder(value -> Component.translatable((String)String.format("config.ok_zoomer.presets.preset.%s", value.toString().toLowerCase(Locale.ROOT))), (Object)ConfigEnums.ZoomPresets.CAMERA).withValues((Object[])ConfigEnums.ZoomPresets.values()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)String.format("config.ok_zoomer.presets.preset.%s.tooltip", value.toString().toLowerCase(Locale.ROOT))))).create(0, 0, 150, 20, (Component)Component.translatable((String)"config.ok_zoomer.presets.preset"));
        Button resetButton = Button.builder((Component)Component.translatable((String)"config.ok_zoomer.presets.apply_preset"), button -> this.resetToPreset((ConfigEnums.ZoomPresets)presetButton.getValue())).tooltip(Tooltip.create((Component)Component.translatable((String)"config.ok_zoomer.presets.apply_preset.tooltip"))).build();
        this.selectionList.addButton((AbstractWidget)presetButton, (AbstractWidget)resetButton);
        for (ValueTreeNode node : config.nodes()) {
            if (!(node instanceof ValueTreeNode.Section)) continue;
            ValueTreeNode.Section section = (ValueTreeNode.Section)node;
            this.selectionList.addCategory(this.configTextUtils.getCategoryText(section.key().toString()));
            for (ValueTreeNode subNode : section) {
                Object button2;
                TrackedValue trackedValue;
                WidgetSize.Size size = (WidgetSize.Size)((Object)subNode.metadata(WidgetSize.TYPE));
                if (!(subNode instanceof TrackedValue)) continue;
                TrackedValue trackie = trackedValue = (TrackedValue)subNode;
                this.newValues.putIfAbsent((TrackedValue<Object>)trackie, trackedValue.getRealValue());
                if (trackedValue.value() instanceof Boolean) {
                    button2 = !trackedValue.equals(OkZoomerConfigManager.CONFIG.tweaks.unbindConflictingKey) ? CycleButton.onOffBuilder((boolean)((Boolean)this.newValues.get(trackie))).withTooltip(value -> Tooltip.create((Component)this.configTextUtils.getOptionTextTooltip(trackedValue))).create(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value)) : Button.builder((Component)Component.translatable((String)"config.ok_zoomer.tweaks.unbind_conflicting_key"), button_ -> ZoomUtils.unbindConflictingKey(this.minecraft, true)).tooltip(Tooltip.create((Component)Component.translatable((String)"config.ok_zoomer.tweaks.unbind_conflicting_key.tooltip"))).build();
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Double) {
                    button2 = new LabelledEditBox(this.font, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.setValue(((Double)this.newValues.get(trackie)).toString());
                    button2.setResponder(arg_0 -> this.lambda$init$6(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.setTooltip(Tooltip.create((Component)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                if (trackedValue.value() instanceof Integer) {
                    button2 = new LabelledEditBox(this.font, 0, 0, 150, 32, this.configTextUtils.getOptionText(trackedValue));
                    button2.setValue(((Integer)this.newValues.get(trackie)).toString());
                    button2.setResponder(arg_0 -> this.lambda$init$7(trackedValue, trackie, (LabelledEditBox)((Object)button2), arg_0));
                    button2.setTooltip(Tooltip.create((Component)this.configTextUtils.getOptionTextTooltip(trackedValue)));
                    this.addOptionToList((AbstractWidget)button2, size);
                    continue;
                }
                button2 = trackedValue.value();
                if (!(button2 instanceof ConfigEnums.ConfigEnum)) continue;
                ConfigEnums.ConfigEnum configEnum = (ConfigEnums.ConfigEnum)button2;
                button2 = CycleButton.builder(value -> this.configTextUtils.getEnumOptionText((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value), (Object)((ConfigEnums.ConfigEnum)this.newValues.get(trackie))).withValues((Object[])((ConfigEnums.ConfigEnum[])((Enum)((Object)configEnum)).getDeclaringClass().getEnumConstants())).withTooltip(value -> Tooltip.create((Component)this.configTextUtils.getEnumOptionTextTooltip((TrackedValue<?>)trackedValue, (ConfigEnums.ConfigEnum)value))).create(0, 0, 150, 20, this.configTextUtils.getOptionText(trackedValue), (button_, value) -> this.newValues.replace((TrackedValue<Object>)trackie, value));
                this.addOptionToList((AbstractWidget)button2, size);
            }
            if (this.buttonBuffer == null) continue;
            this.selectionList.addButton(this.buttonBuffer, null);
            this.buttonBuffer = null;
        }
        this.addRenderableWidget((GuiEventListener)this.selectionList);
        this.layout.addTitleHeader(this.title, this.font);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footerLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"config.ok_zoomer.discard_changes"), button -> this.resetNewValues()).width(150).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(150).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.selectionList.updateSize(this.width, this.layout);
    }

    private void addOptionToList(AbstractWidget button, WidgetSize.Size size) {
        if (size == WidgetSize.Size.HALF) {
            if (this.buttonBuffer == null) {
                this.buttonBuffer = button;
            } else {
                this.selectionList.addButton(this.buttonBuffer, button);
                this.buttonBuffer = null;
            }
        } else {
            if (this.buttonBuffer != null) {
                this.selectionList.addButton(this.buttonBuffer, null);
                this.buttonBuffer = null;
            }
            this.selectionList.addButton(button);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void removed() {
        this.newValues.forEach((trackedValue, newValue) -> {
            if (!this.invalidValues.contains(trackedValue)) {
                trackedValue.setValue(newValue, false);
            }
        });
        OkZoomerConfigManager.CONFIG.save();
    }

    private void refresh() {
        double scrollAmount = this.selectionList.scrollAmount();
        this.rebuildWidgets();
        this.selectionList.setScrollAmount(scrollAmount);
    }

    private void resetNewValues() {
        this.newValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            if (trackedValue.getRealValue() == null) continue;
            this.newValues.put((TrackedValue<Object>)trackedValue, trackedValue.getRealValue());
        }
        this.refresh();
    }

    public void resetToPreset(ConfigEnums.ZoomPresets preset) {
        this.newValues.clear();
        this.invalidValues.clear();
        for (TrackedValue trackedValue : OkZoomerConfigManager.CONFIG.values()) {
            this.newValues.put((TrackedValue<Object>)trackedValue, ZoomPresets.PRESET_ENUM_TO_PRESET.get(preset).getOrDefault(trackedValue, trackedValue.getDefaultValue()));
        }
        this.refresh();
    }

    private /* synthetic */ void lambda$init$7(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Integer)range.min(), min);
                max = Math.min((Integer)range.max(), max);
            }
            int parsedValue = Integer.parseInt(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.setTextColor(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.setTextColor(-65536);
        }
    }

    private /* synthetic */ void lambda$init$6(TrackedValue trackedValue, TrackedValue trackie, LabelledEditBox button, String value) {
        try {
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            for (Constraint constraint : trackedValue.constraints()) {
                if (!(constraint instanceof Constraint.Range)) continue;
                Constraint.Range range = (Constraint.Range)constraint;
                min = Math.max((Double)range.min(), min);
                max = Math.min((Double)range.max(), max);
            }
            double parsedValue = Double.parseDouble(value);
            if (parsedValue < min || parsedValue > max) {
                throw new IndexOutOfBoundsException();
            }
            this.newValues.replace((TrackedValue<Object>)trackie, parsedValue);
            this.invalidValues.remove(trackie);
            button.setTextColor(-2039584);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.invalidValues.add((TrackedValue<Object>)trackie);
            button.setTextColor(-65536);
        }
    }
}

