/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.base;

import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ListWidget
extends ContainerWidget {
    private static final int SCROLLBAR_WIDTH = 2;
    private static final int SCROLLBAR_PADDING = 4;
    private static final int OVERSCROLL = 2;
    protected final List<Item> items = new ArrayList<Item>();
    private double scroll = 0.0;
    private int lastHeight = 0;
    private boolean scrolling = false;

    public ListWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void update(ListWidget old) {
        if (this.items.size() != old.items.size()) {
            return;
        }
        if (this.height != old.height) {
            return;
        }
        this.updateLastHeight();
        if (this.lastHeight != old.lastHeight) {
            return;
        }
        this.scroll = old.scroll;
        this.scrolling = old.scrolling;
    }

    public void add(Item item) {
        this.items.add(item);
        this.updateScrollBar();
    }

    @Override
    public void clear() {
        super.clear();
        this.items.clear();
    }

    @Override
    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.items;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean showsScrollBar = this.lastHeight > this.height;
        int actualWidth = this.getWidth() - (showsScrollBar ? 6 : 0);
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + actualWidth, this.getY() + this.height);
        int y = this.getY() - (int)this.scroll + 1;
        this.lastHeight = 0;
        for (Item item : this.items) {
            item.setItemWidth(actualWidth);
            item.setX(this.getX());
            item.setY(y);
            item.render(graphics, mouseX, mouseY, partialTicks);
            y += item.getHeight();
            this.lastHeight += item.getHeight();
        }
        graphics.disableScissor();
        if (this.lastHeight > this.height) {
            int scrollBarHeight = (int)((double)this.height / (double)this.lastHeight * (double)this.height) - 8;
            int scrollBarX = this.getX() + this.width - 2 - 1;
            int scrollBarY = this.getY() + 4 + (int)(this.scroll / (double)this.lastHeight * (double)this.height);
            int scrollBarColor = this.isMouseOver(mouseX, mouseY) && mouseX >= scrollBarX && mouseX <= scrollBarX + 2 && mouseY >= scrollBarY && mouseY <= scrollBarY + scrollBarHeight ? -986896 : -4144960;
            graphics.fill(scrollBarX, scrollBarY, scrollBarX + 2, scrollBarY + scrollBarHeight, scrollBarColor);
        }
    }

    @Override
    public boolean mouseDragged(@NotNull MouseButtonEvent event, double dragX, double dragY) {
        if (this.scrolling) {
            double scrollBarHeight = (double)this.height / (double)this.lastHeight * (double)this.height;
            double scrollBarDragY = dragY / ((double)this.height - scrollBarHeight);
            this.scroll = Mth.clamp((double)(this.scroll + scrollBarDragY * (double)this.lastHeight), (double)0.0, (double)Math.max(0, this.lastHeight - this.height + 2));
            return true;
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scroll = Mth.clamp((double)(this.scroll - scrollY * 10.0), (double)0.0, (double)Math.max(0, this.lastHeight - this.height + 2));
        return true;
    }

    @Override
    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (this.isMouseOver(event.x(), event.y())) {
            if (this.isMouseOverScrollBar(event.x(), event.y())) {
                this.scrolling = true;
                return true;
            }
            return super.mouseClicked(event, bl);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(@NotNull MouseButtonEvent event) {
        if (event.input() == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(event);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        if (this.lastHeight > this.height) {
            int scrollBarX = this.getX() + this.width - 2 - 1;
            return mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 2) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height);
        }
        return false;
    }

    protected void updateLastHeight() {
        boolean showsScrollBar = this.lastHeight > this.height;
        int actualWidth = this.getWidth() - (showsScrollBar ? 6 : 0);
        this.lastHeight = 0;
        int y = this.getY() - (int)this.scroll + 1;
        for (Item item : this.items) {
            item.setItemWidth(actualWidth);
            item.setX(this.getX());
            item.setY(y);
            this.lastHeight += item.getHeight();
            y += item.getHeight();
        }
    }

    protected void updateScrollBar() {
        this.updateLastHeight();
        this.scroll = Mth.clamp((double)this.scroll, (double)0.0, (double)Math.max(0, this.lastHeight - this.height + 2));
    }

    public static interface Item
    extends GuiEventListener,
    Renderable,
    NarratableEntry,
    LayoutElement {
        @NotNull
        default public ScreenRectangle getRectangle() {
            return super.getRectangle();
        }

        public void setItemWidth(int var1);
    }
}

