/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text.multiline;

import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineStringView;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineTextState;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.util.Mth;

class MultilineTextInput
extends MultilineTextState {
    public MultilineTextInput(ListenableState<String> state) {
        super(state);
    }

    public boolean onMouseDrag(double mouseX, double mouseY, int button) {
        this.selecting = true;
        boolean result = this.onMouseClick(mouseX, mouseY, button);
        this.selecting = false;
        return result;
    }

    public boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int lineX = Mth.floor((double)mouseX);
            int lineY = Mth.floor((double)(mouseY / 9.0));
            MultilineStringView line = (MultilineStringView)this.lines.get(Mth.clamp((int)lineY, (int)0, (int)(this.lines.size() - 1)));
            int k = this.font.plainSubstrByWidth(this.value.substring(line.start(), line.end()), lineX).length();
            this.seekCursor(Whence.ABSOLUTE, line.start() + k);
            return true;
        }
        return false;
    }

    public boolean onCharTyped(CharacterEvent event) {
        this.insertText(event.codepointAsString());
        return true;
    }

    public boolean onKeyPress(KeyEvent event) {
        if (event.isSelectAll()) {
            this.cursor = this.value.length();
            this.selectCursor = 0;
        } else if (event.isCopy()) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.selection().substring(this.value));
        } else if (event.isPaste()) {
            this.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
        } else if (event.isCut()) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.selection().substring(this.value));
            this.insertText("");
        } else {
            switch (event.input()) {
                case 257: 
                case 335: {
                    this.insertText("\n");
                    break;
                }
                case 259: {
                    if (event.hasControlDown()) {
                        this.deleteText(this.getPreviousWordStart() - this.cursor);
                        break;
                    }
                    this.deleteText(-1);
                    break;
                }
                case 261: {
                    if (event.hasControlDown()) {
                        this.deleteText(this.getNextWordStart() - this.cursor);
                        break;
                    }
                    this.deleteText(1);
                    break;
                }
                case 262: {
                    if (event.hasControlDown()) {
                        this.seekCursor(Whence.ABSOLUTE, this.getNextWordStart());
                        break;
                    }
                    this.seekCursor(Whence.RELATIVE, 1);
                    break;
                }
                case 263: {
                    if (event.hasControlDown()) {
                        this.seekCursor(Whence.ABSOLUTE, this.getPreviousWordStart());
                        break;
                    }
                    this.seekCursor(Whence.RELATIVE, -1);
                    break;
                }
                case 264: {
                    if (event.hasControlDown()) break;
                    this.moveCursorY(1);
                    break;
                }
                case 265: {
                    if (event.hasControlDown()) break;
                    this.moveCursorY(-1);
                    break;
                }
                case 266: {
                    this.seekCursor(Whence.ABSOLUTE, 0);
                    break;
                }
                case 267: {
                    this.seekCursor(Whence.END, 0);
                    break;
                }
                case 268: {
                    if (event.hasControlDown()) {
                        this.seekCursor(Whence.ABSOLUTE, 0);
                        break;
                    }
                    this.seekCursor(Whence.ABSOLUTE, this.getCursorLineView().start());
                    break;
                }
                case 269: {
                    if (event.hasControlDown()) {
                        this.seekCursor(Whence.END, 0);
                        break;
                    }
                    this.seekCursor(Whence.ABSOLUTE, this.getCursorLineView().end());
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

