/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineTextBox;
import com.teamresourceful.resourcefulconfig.client.screens.base.ModalOverlay;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class MultilineStringOptionWidget
extends BaseWidget {
    private static final int WIDTH = 80;
    private static final int SIZE = 12;
    private static final int SPACING = 4;
    private static final int PADDING = 2;
    private final Supplier<String> getter;
    private final Consumer<String> setter;

    public MultilineStringOptionWidget(Supplier<String> getter, Consumer<String> setter) {
        super(80, 16);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int contentWidth = this.font.width((FormattedText)UIConstants.EDIT) + 4 + 12;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.EDIT, this.getX() + (this.getWidth() - contentWidth) / 2, this.getY() + 2, 12, 12);
        int n = this.getX() + (this.getWidth() - contentWidth) / 2 + 12 + 4;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, UIConstants.EDIT, n, n2 + (n3 - 9) / 2 + 1, -329226);
        this.applyCursor(graphics);
    }

    public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
        new MutlilineStringOverlay(this.getter, this.setter).open();
    }

    private static class MutlilineStringOverlay
    extends ModalOverlay {
        private final Supplier<String> getter;
        private final Consumer<String> setter;

        protected MutlilineStringOverlay(Supplier<String> getter, Consumer<String> setter) {
            this.title = UIConstants.EDIT_STRING;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        protected void init() {
            super.init();
            MultilineTextBox box = new MultilineTextBox(State.of(this.setter, this.getter));
            box.setX(this.left);
            box.setY(this.top);
            box.withFont(this.font);
            box.setWidth(this.contentWidth);
            box.setHeight(this.contentHeight);
            this.addRenderableWidget((GuiEventListener)box);
        }

        @Override
        public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderBackground(graphics, mouseX, mouseY, partialTicks);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.left, this.top, this.contentWidth, this.contentHeight);
        }
    }
}

