/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.compat.minecraft;

import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.common.compat.minecraft.DedicatedServerInfo;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.dedicated.DedicatedServer;

public class DedicatedServerConfigEntry<T>
implements ResourcefulConfigValueEntry {
    private final EntryType type;
    private final EntryData options;
    private final T defaultValue;
    private final Supplier<T> getter;
    private final Function<T, Boolean> setter;

    public static DedicatedServerConfigEntry<Boolean> of(String id, boolean defaultValue, Function<DedicatedServer, Boolean> getter, BiConsumer<DedicatedServer, Boolean> setter) {
        return new DedicatedServerConfigEntry<Boolean>(id, EntryType.BOOLEAN, defaultValue, getter, setter);
    }

    public static DedicatedServerConfigEntry<Integer> of(String id, int defaultValue, Function<DedicatedServer, Integer> getter, BiConsumer<DedicatedServer, Integer> setter) {
        return new DedicatedServerConfigEntry<Integer>(id, EntryType.INTEGER, defaultValue, getter, setter);
    }

    public static DedicatedServerConfigEntry<String> of(String id, String defaultValue, Function<DedicatedServer, String> getter, BiConsumer<DedicatedServer, String> setter) {
        return new DedicatedServerConfigEntry<String>(id, EntryType.STRING, defaultValue, getter, setter);
    }

    private DedicatedServerConfigEntry(String id, EntryType type, T defaultValue, Function<DedicatedServer, T> getter, BiConsumer<DedicatedServer, T> setter) {
        this.type = type;
        this.options = EntryData.builder().translation(id, "rconfig.server.properties." + id).comment("", "rconfig.server.properties." + id + ".desc").build();
        this.defaultValue = defaultValue;
        this.getter = () -> {
            DedicatedServer server = DedicatedServerInfo.getServer();
            return server == null ? this.defaultValue : getter.apply(server);
        };
        this.setter = newValue -> {
            DedicatedServer server = DedicatedServerInfo.getServer();
            if (server == null) {
                return false;
            }
            setter.accept(server, newValue);
            return true;
        };
        if (type == EntryType.ENUM || EntryType.OBJECT == type) {
            throw new IllegalArgumentException("EntryType cannot be ENUM or OBJECT");
        }
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<?> objectType() {
        return switch (this.type) {
            case EntryType.BOOLEAN -> Boolean.TYPE;
            case EntryType.BYTE -> Byte.TYPE;
            case EntryType.SHORT -> Short.TYPE;
            case EntryType.INTEGER -> Integer.TYPE;
            case EntryType.LONG -> Long.TYPE;
            case EntryType.FLOAT -> Float.TYPE;
            case EntryType.DOUBLE -> Double.TYPE;
            case EntryType.STRING -> String.class;
            default -> null;
        };
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public Object get() {
        return this.getter.get();
    }

    @Override
    public Object[] getArray() {
        return new Object[0];
    }

    @Override
    public boolean setArray(Object[] array) {
        return false;
    }

    @Override
    public byte getByte() {
        return 0;
    }

    @Override
    public boolean setByte(byte value) {
        return false;
    }

    @Override
    public short getShort() {
        return 0;
    }

    @Override
    public boolean setShort(short value) {
        return false;
    }

    @Override
    public int getInt() {
        if (this.type != EntryType.INTEGER) {
            return 0;
        }
        try {
            return (Integer)this.get();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public boolean setInt(int value) {
        if (this.type != EntryType.INTEGER) {
            return false;
        }
        return this.setter.apply(value);
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public boolean setLong(long value) {
        return false;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public boolean setFloat(float value) {
        return false;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public boolean setDouble(double value) {
        return false;
    }

    @Override
    public boolean getBoolean() {
        if (this.type != EntryType.BOOLEAN) {
            return false;
        }
        return (Boolean)this.get();
    }

    @Override
    public boolean setBoolean(boolean value) {
        if (this.type != EntryType.BOOLEAN) {
            return false;
        }
        return this.setter.apply(value);
    }

    @Override
    public String getString() {
        if (this.type != EntryType.STRING) {
            return null;
        }
        return (String)this.get();
    }

    @Override
    public boolean setString(String value) {
        if (this.type != EntryType.STRING) {
            return false;
        }
        return this.setter.apply(value);
    }

    @Override
    public Enum<?> getEnum() {
        return null;
    }

    @Override
    public boolean setEnum(Enum<?> value) {
        return false;
    }

    @Override
    public EntryType type() {
        return this.type;
    }

    @Override
    public EntryData options() {
        return this.options;
    }

    @Override
    public void reset() {
        this.setter.apply(this.defaultValue);
    }
}

