/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;

@ApiSide.ClientOnly
public class HealthComponent
implements ITooltipComponent {
    private static final Identifier SPRITE_CONTAINER = Identifier.withDefaultNamespace((String)"hud/heart/container");
    private static final Identifier SPRITE_NORMAL_FULL = Identifier.withDefaultNamespace((String)"hud/heart/full");
    private static final Identifier SPRITE_NORMAL_HALF = Identifier.withDefaultNamespace((String)"hud/heart/half");
    private static final Identifier SPRITE_ABSORBING_FULL = Identifier.withDefaultNamespace((String)"hud/heart/absorbing_full");
    private static final Identifier SPRITE_ABSORBING_HALF = Identifier.withDefaultNamespace((String)"hud/heart/absorbing_half");
    private final int health;
    private final int iconCount;
    private final int lineWidth;
    private final boolean absorption;

    public HealthComponent(float health, float maxHealth, int maxPerLine, boolean absorption) {
        this.health = Mth.ceil((float)health);
        this.iconCount = Mth.positiveCeilDiv((int)Mth.ceil((float)Math.max(health, maxHealth)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
        this.absorption = absorption;
    }

    @Override
    public int getWidth() {
        return this.lineWidth * 8 + 1;
    }

    @Override
    public int getHeight() {
        return Mth.positiveCeilDiv((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        int filled = this.health / 2 - 1;
        int half = filled + this.health % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            ctx.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITE_CONTAINER, ix, iy, 9, 9);
            if (i <= filled) {
                ctx.blitSprite(RenderPipelines.GUI_TEXTURED, this.absorption ? SPRITE_ABSORBING_FULL : SPRITE_NORMAL_FULL, ix, iy, 9, 9);
                continue;
            }
            if (i != half) continue;
            ctx.blitSprite(RenderPipelines.GUI_TEXTURED, this.absorption ? SPRITE_ABSORBING_HALF : SPRITE_NORMAL_HALF, ix, iy, 9, 9);
        }
    }
}

