/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.Objects;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class FluidData
implements IData {
    public static final Identifier ID = BuiltinDataUtil.rl("fluid");
    public static final IData.Type<FluidData> TYPE = IData.createType(ID);
    public static final Identifier CONFIG_DISPLAY_UNIT = BuiltinDataUtil.rl("fluid.display_unit");

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(T fluid, FluidDescriptor<T> descriptor) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            Preconditions.checkArgument((flowing == flowing.getSource() ? 1 : 0) != 0, (Object)"Not a source fluid");
        }
        IExtraService.INSTANCE.setFluidDescFor(fluid, descriptor);
    }

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(Class<T> clazz, FluidDescriptor<T> descriptor) {
        IExtraService.INSTANCE.setFluidDescFor(clazz, descriptor);
    }

    public static void describeCauldron(Block block, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(block, descriptor);
    }

    public static void describeCauldron(Class<? extends Block> clazz, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(clazz, descriptor);
    }

    public static FluidData of(Unit unit) {
        return IExtraService.INSTANCE.createFluidData(null, unit, -1);
    }

    public static FluidData of(Unit unit, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(null, unit, slotCountHint);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), -1);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), slotCountHint);
    }

    public FluidData add(Fluid fluid, DataComponentPatch data, double stored, double capacity) {
        Fluid fluid2;
        Objects.requireNonNull(fluid, "Fluid can't be null");
        Objects.requireNonNull(data, "Data can't be null, use EMPTY");
        capacity = Math.max(capacity, 0.0);
        stored = Mth.clamp((double)stored, (double)0.0, (double)capacity);
        if (capacity == 0.0) {
            capacity = Double.POSITIVE_INFINITY;
        }
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluid2 = flowing.getSource();
        } else {
            fluid2 = fluid;
        }
        Fluid source = fluid2;
        this.implAdd(source, data, stored, capacity);
        return this;
    }

    protected abstract PlatformTranslator<Object> translator();

    protected abstract void implAdd(Fluid var1, DataComponentPatch var2, double var3, double var5);

    @ApiSide.ClientOnly
    @ApiStatus.OverrideOnly
    public static interface FluidDescriptor<T extends Fluid> {
        public void describeFluid(FluidDescriptionContext<T> var1, FluidDescription var2);
    }

    @ApiStatus.OverrideOnly
    public static interface CauldronDescriptor {
        public @Nullable FluidData getCauldronFluidData(BlockState var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.OverrideOnly
    public static interface PlatformTranslator<T> {
        public Unit unit();

        public Fluid fluid(T var1);

        public DataComponentPatch data(T var1);

        public double amount(T var1) throws UnsupportedOperationException;
    }

    public static enum Unit {
        MILLIBUCKETS("mB"),
        DROPLETS("dp");

        public final String symbol;

        public static double convert(Unit from, Unit to, double amount) {
            if (from == to) {
                return amount;
            }
            return switch (to.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> amount / 81.0;
                case 1 -> amount * 81.0;
            };
        }

        private Unit(String symbol) {
            this.symbol = symbol;
        }
    }

    @ApiStatus.NonExtendable
    public static abstract class PlatformDependant<T>
    extends FluidData {
        public PlatformDependant<T> add(T stack, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(stack), translator.data(stack), translator.amount(stack), capacity);
        }

        public PlatformDependant<T> add(T variant, double stored, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(variant), translator.data(variant), stored, capacity);
        }

        @Override
        public PlatformDependant<T> add(Fluid fluid, DataComponentPatch data, double stored, double capacity) {
            super.add(fluid, data, stored, capacity);
            return this;
        }
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescriptionContext<T extends Fluid> {
        public T fluid();

        public DataComponentPatch data();
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescription {
        public FluidDescription name(Component var1);

        public FluidDescription sprite(TextureAtlasSprite var1);

        public FluidDescription tint(int var1);
    }
}

