/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.plugin.PluginInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.Identifier;

public abstract class CommonCommand<S, E extends Executor> {
    private final String root;

    protected CommonCommand(String root) {
        this.root = root;
    }

    protected abstract void register(ArgumentBuilderBuilder<S> var1);

    protected abstract LiteralArgumentBuilder<S> literal(String var1);

    protected abstract <T> RequiredArgumentBuilder<S, T> argument(String var1, ArgumentType<T> var2);

    protected abstract void success(S var1, Supplier<Component> var2);

    protected abstract void fail(S var1, Component var2);

    protected abstract E getExecutor(S var1);

    protected abstract void reloadPlugins(E var1);

    protected abstract boolean pluginCommandRequirement(S var1);

    protected boolean isPluginDisabledOnServer(PluginInfo plugin) {
        return false;
    }

    public final void register(CommandDispatcher<S> dispatcher) {
        new ArgumentBuilderBuilder<S>(this.literal(this.root)).then((ArgumentBuilder<S, ?>)this.literal("plugin")).requires(this::pluginCommandRequirement).then((ArgumentBuilder<Object, ?>)this.literal("list")).executes((Command<Object>)((Command)context -> {
            Object source = context.getSource();
            return this.listPlugins(source, true) + this.listPlugins(source, false);
        })).then((ArgumentBuilder<Object, ?>)this.literal("enabled")).executes((Command<Object>)((Command)context -> this.listPlugins(context.getSource(), true))).pop("enabled").then((ArgumentBuilder<Object, ?>)this.literal("available")).executes((Command<Object>)((Command)context -> this.listPlugins(context.getSource(), false))).pop("available").pop("list").then((ArgumentBuilder<Object, ?>)this.literal("enable")).then((ArgumentBuilder<Object, ?>)this.argument("name", (ArgumentType)IdentifierArgument.id())).suggests(this.suggestPlugins(false)).executes((Command<Object>)((Command)context -> this.modifyPlugin(context, true))).pop("name", "enable").then((ArgumentBuilder<Object, ?>)this.literal("disable")).then((ArgumentBuilder<Object, ?>)this.argument("name", (ArgumentType)IdentifierArgument.id())).suggests(this.suggestPlugins(true)).executes((Command<Object>)((Command)context -> this.modifyPlugin(context, false))).pop("name", "disable").then((ArgumentBuilder<Object, ?>)this.literal("reload")).executes((Command<Object>)((Command)context -> {
            Object source = context.getSource();
            E executor = this.getExecutor(source);
            executor.execute(() -> this.reloadPlugins(executor));
            this.success(source, () -> Component.translatable((String)"command.waila.plugin.reload"));
            return 1;
        })).pop("reload").pop("plugin").then(this::register).register(dispatcher);
    }

    private Stream<PluginInfo> getPlugins(boolean enabled) {
        return PluginInfo.getAll().stream().filter(it -> enabled == it.isEnabled());
    }

    private int listPlugins(S source, boolean enabled) {
        List<PluginInfo> plugins = this.getPlugins(enabled).toList();
        if (plugins.isEmpty()) {
            this.success(source, () -> Component.translatable((String)(enabled ? "command.waila.plugin.list.enabled.none" : "command.waila.plugin.list.available.none")));
        } else {
            this.success(source, () -> Component.translatable((String)(enabled ? "command.waila.plugin.list.enabled.success" : "command.waila.plugin.list.available.success"), (Object[])new Object[]{plugins.size(), ComponentUtils.formatList((Collection)plugins, p -> ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)p.getPluginId().toString())).withStyle(s -> s.withColor(enabled ? ChatFormatting.GREEN : ChatFormatting.RED).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.empty().append(p.getModInfo().getName())))))}));
        }
        return plugins.size();
    }

    private SuggestionProvider<S> suggestPlugins(boolean enabled) {
        return (context, builder) -> SharedSuggestionProvider.suggestResource(this.getPlugins(enabled).filter(it -> !it.isLocked() && !this.isPluginDisabledOnServer((PluginInfo)it)).map(PluginInfo::getPluginId), (SuggestionsBuilder)builder);
    }

    private int modifyPlugin(CommandContext<S> context, boolean enable) {
        Object source = context.getSource();
        E executor = this.getExecutor(source);
        Identifier id = (Identifier)context.getArgument("name", Identifier.class);
        String name = id.toString();
        PluginInfo plugin = PluginInfo.get(id);
        if (plugin == null) {
            this.fail(source, (Component)Component.translatable((String)"command.waila.plugin.unknown", (Object[])new Object[]{name}));
            return 0;
        }
        if (plugin.isLocked()) {
            this.fail(source, (Component)Component.translatable((String)"command.waila.plugin.locked", (Object[])new Object[]{name}));
            return 0;
        }
        if (this.isPluginDisabledOnServer(plugin)) {
            this.fail(source, (Component)Component.translatable((String)"command.waila.plugin.disabled_on_server", (Object[])new Object[]{name}));
            return 0;
        }
        executor.execute(() -> {
            plugin.setEnabled(enable);
            this.reloadPlugins(executor);
        });
        this.success(source, () -> Component.translatable((String)(enable ? "command.waila.plugin.modify.enable" : "command.waila.plugin.modify.disable"), (Object[])new Object[]{name}));
        return 1;
    }
}

