/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.util.WRenders;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.jspecify.annotations.Nullable;

public abstract class ComponentRenderer {
    private static final Random RANDOM = new Random();
    private static @Nullable ComponentRenderer current = null;

    public abstract void render(GuiGraphics var1, ITooltipComponent var2, int var3, int var4, int var5, int var6, DeltaTracker var7);

    public static ComponentRenderer get() {
        if (current == null) {
            current = Default.INSTANCE;
        }
        return current;
    }

    public static void set(@Nullable ComponentRenderer value) {
        if (value == null) {
            value = Default.INSTANCE;
        }
        current = value;
    }

    public static class Default
    extends ComponentRenderer {
        public static final Default INSTANCE = new Default();

        @Override
        public void render(GuiGraphics ctx, ITooltipComponent component, int x, int y, int cw, int ch, DeltaTracker delta) {
            component.render(ctx, x, y, delta);
            if (WailaClient.showComponentBounds) {
                ctx.nextStratum();
                Default.renderBounds(ctx, x, y, cw, ch, 1.0f);
            }
        }

        public static void renderBounds(GuiGraphics ctx, int x, int y, int cw, int ch, float v) {
            ctx.pose().pushMatrix();
            float scale = Minecraft.getInstance().getWindow().getGuiScale();
            ctx.pose().scale(1.0f / scale, 1.0f / scale);
            int bx = Mth.floor((double)((double)((float)x * scale) + 0.5));
            int by = Mth.floor((double)((double)((float)y * scale) + 0.5));
            int bw = Mth.floor((double)((double)((float)cw * scale) + 0.5));
            int bh = Mth.floor((double)((double)((float)ch * scale) + 0.5));
            int color = -16777216 + Mth.hsvToRgb((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)v);
            WRenders.state(ctx).submitGuiElement((GuiElementRenderState)new BoundsRenderState(new Matrix3x2f((Matrix3x2fc)ctx.pose()), new ScreenRectangle(bx, by, bw, bh), color));
            ctx.pose().popMatrix();
        }
    }

    private record BoundsRenderState(Matrix3x2f pose, ScreenRectangle bounds, int color) implements GuiElementRenderState
    {
        public void buildVertices(VertexConsumer buf) {
            DisplayUtil.renderRectBorder(this.pose, buf, this.bounds.left(), this.bounds.top(), this.bounds.width(), this.bounds.height(), 1, this.color, this.color);
        }

        public RenderPipeline pipeline() {
            return RenderPipelines.GUI;
        }

        public TextureSetup textureSetup() {
            return TextureSetup.noTexture();
        }

        public @Nullable ScreenRectangle scissorArea() {
            return null;
        }
    }
}

