/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;

public class BooleanValue
extends ConfigValue<Boolean, BooleanValue> {
    private final Button button = DisplayUtil.createButton(0, 0, 100, 20, (Component)Component.empty(), w -> this.setValue((Boolean)this.getValue() == false));

    public BooleanValue(String optionName, boolean value, @Nullable Boolean defaultValue, Consumer<Boolean> save) {
        super(optionName, value, defaultValue, save);
        this.setMessage();
    }

    @Override
    protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.setMessage();
        this.button.active = !this.isDisabled();
        this.button.setX(x + width - this.button.getWidth());
        this.button.setY(y + (height - this.button.getHeight()) / 2);
        this.button.render(ctx, mouseX, mouseY, partialTicks);
    }

    private void setMessage() {
        this.button.setMessage((Component)Component.translatable((String)((Boolean)this.getValue() != false ? "config.waila.true" : "config.waila.false")).withStyle(this.isDisabled() ? ChatFormatting.GRAY : ((Boolean)this.getValue() != false ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ").append(this.getValue());
    }

    @Override
    public GuiEventListener getListener() {
        return this.button;
    }
}

