/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IWailaClientPlugin;
import mcp.mobius.waila.api.IWailaCommonPlugin;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.plugin.PluginSide;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import mcp.mobius.waila.util.ResourceLocationSerde;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class PluginInfo
implements IPluginInfo {
    private static final Log LOG = Log.create();
    private static final Identifier CORE = Waila.id("core");
    private static final IJsonConfig<Map<Identifier, Boolean>> TOGGLE = IJsonConfig.of(new TypeToken<Map<Identifier, Boolean>>(){}).file("waila/plugin_toggle").factory(LinkedHashMap::new).json5().gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Identifier.class, (Object)ResourceLocationSerde.INSTANCE).create()).build();
    private static final Map<Identifier, PluginInfo> PLUGIN_ID_TO_PLUGIN_INFO = new LinkedHashMap<Identifier, PluginInfo>();
    private static final CachedSupplier<Map<String, List<PluginInfo>>> MOD_ID_TO_PLUGIN_INFOS = new CachedSupplier<Map>(() -> PLUGIN_ID_TO_PLUGIN_INFO.values().stream().collect(Collectors.groupingBy(p -> p.getModInfo().getId())));
    private static final IWailaPlugin EMPTY_INIT = registrar -> {};
    private final ModInfo modInfo;
    private final Identifier pluginId;
    private final PluginSide side;
    private final List<String> requiredModIds;
    private final boolean legacy;
    private final @Nullable IWailaPlugin deprecatedInit;
    private final @Nullable java.util.function.Supplier<@Nullable IWailaCommonPlugin> common;
    private final @Nullable java.util.function.Supplier<@Nullable IWailaClientPlugin> client;
    private boolean disabledOnServer;

    private PluginInfo(ModInfo modInfo, Identifier pluginId, PluginSide side, @Nullable IWailaPlugin deprecatedInit, List<String> requiredModIds, boolean legacy, @Nullable java.util.function.Supplier<@Nullable IWailaCommonPlugin> common, @Nullable java.util.function.Supplier<@Nullable IWailaClientPlugin> client) {
        this.modInfo = modInfo;
        this.pluginId = pluginId;
        this.side = side;
        this.deprecatedInit = deprecatedInit;
        this.requiredModIds = requiredModIds;
        this.legacy = legacy;
        this.common = common;
        this.client = client;
    }

    private static boolean isDuplicate(Identifier rl) {
        if (PLUGIN_ID_TO_PLUGIN_INFO.containsKey(rl)) {
            LOG.error("Duplicate plugin id " + String.valueOf(rl));
            return true;
        }
        return false;
    }

    public static void register(String modId, String pluginIdStr, PluginSide side, @Nullable String commonCls, @Nullable String clientCls, List<String> required, boolean defaultEnabled) {
        Identifier rl = Identifier.parse((String)pluginIdStr);
        if (PluginInfo.isDuplicate(rl)) {
            return;
        }
        if (rl.getNamespace().equals("minecraft")) {
            LOG.warn("Plugin " + commonCls + " is using the default namespace " + String.valueOf(rl));
        }
        Supplier common = commonCls == null ? null : Suppliers.memoize(() -> {
            try {
                return (IWailaCommonPlugin)Class.forName(commonCls).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.error("Error creating instance of plugin " + pluginIdStr, t);
                return null;
            }
        });
        Supplier client = clientCls == null ? null : Suppliers.memoize(() -> {
            try {
                return (IWailaClientPlugin)Class.forName(clientCls).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.error("Error creating instance of plugin " + pluginIdStr, t);
                return null;
            }
        });
        PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, null, required, false, (java.util.function.Supplier<IWailaCommonPlugin>)common, (java.util.function.Supplier<IWailaClientPlugin>)client));
        TOGGLE.get().put(rl, defaultEnabled);
    }

    public static void registerDeprecated(String modId, String pluginIdStr, PluginSide side, String initializerStr, List<String> required, boolean defaultEnabled, boolean legacy) {
        try {
            Identifier rl = Identifier.parse((String)pluginIdStr);
            if (PluginInfo.isDuplicate(rl)) {
                return;
            }
            if (rl.getNamespace().equals("minecraft")) {
                LOG.warn("Plugin " + initializerStr + " is using the default namespace " + String.valueOf(rl));
            }
            IWailaPlugin initializer = (IWailaPlugin)Class.forName(initializerStr).getConstructor(new Class[0]).newInstance(new Object[0]);
            PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, initializer, required, legacy, null, null));
            TOGGLE.get().putIfAbsent(rl, defaultEnabled);
        }
        catch (Throwable t) {
            LOG.error("Error creating instance of plugin " + pluginIdStr, t);
        }
    }

    public static @Nullable PluginInfo get(Identifier pluginId) {
        return PLUGIN_ID_TO_PLUGIN_INFO.get(pluginId);
    }

    public static Collection<PluginInfo> getAllFromMod(String modId) {
        return MOD_ID_TO_PLUGIN_INFOS.get().get(modId);
    }

    public static Collection<PluginInfo> getAll() {
        return PLUGIN_ID_TO_PLUGIN_INFO.values();
    }

    @Override
    public IModInfo getModInfo() {
        return this.modInfo;
    }

    @Override
    public Identifier getPluginId() {
        return this.pluginId;
    }

    @Override
    public IPluginInfo.Side getSide() {
        return this.side.toDeprecated();
    }

    @Override
    public IWailaPlugin getInitializer() {
        if (this.deprecatedInit == null) {
            return EMPTY_INIT;
        }
        return this.deprecatedInit;
    }

    public @Nullable IWailaPlugin getDeprecatedInit() {
        return this.deprecatedInit;
    }

    public @Nullable IWailaCommonPlugin getCommon() {
        if (this.common == null) {
            return null;
        }
        return this.common.get();
    }

    public @Nullable IWailaClientPlugin getClient() {
        if (this.client == null) {
            return null;
        }
        if (!Waila.CLIENT_SIDE) {
            return null;
        }
        return this.client.get();
    }

    @Override
    public List<String> getRequiredModIds() {
        return this.requiredModIds;
    }

    @Override
    public boolean isEnabled() {
        if (this.disabledOnServer) {
            return false;
        }
        return this.isLocked() || TOGGLE.get().get(this.getPluginId()) != false;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isLocked() {
        return this.pluginId.equals((Object)CORE);
    }

    public boolean isDisabledOnServer() {
        return this.disabledOnServer;
    }

    public void setDisabledOnServer(boolean disabledOnServer) {
        this.disabledOnServer = disabledOnServer;
    }

    public void setEnabled(boolean enabled) {
        TOGGLE.get().put(this.getPluginId(), enabled);
    }

    public static void refresh() {
        TOGGLE.invalidate();
        PluginInfo.getAll().forEach(it -> {
            it.disabledOnServer = false;
        });
    }

    public static void saveToggleConfig() {
        TOGGLE.save();
    }
}

