/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.theme;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeAccessor;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Range;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.jspecify.annotations.Nullable;

public class NinePatchTheme
implements ITheme {
    public static final IThemeType<NinePatchTheme> TYPE = IThemeType.of(NinePatchTheme.class).property("texture", "waila:textures/ninepatch_example.png").property("useResourcePack", true).property("textColor", IntFormat.RGB_HEX, 0xA0A0A0).property("textureWidth", 16).property("textureHeight", 16).property("regionTop", 3).property("regionBottom", 3).property("regionLeft", 3).property("regionRight", 3).property("mode", Mode.STRETCH).build();
    private static final Identifier PATH_TEXTURE_ID = Identifier.fromNamespaceAndPath((String)"waila", (String)"nine_patch_path");
    private String texture;
    private boolean useResourcePack;
    private int textColor;
    private int textureWidth;
    private int textureHeight;
    private int regionTop;
    private int regionBottom;
    private int regionLeft;
    private int regionRight;
    private Mode mode;
    private TextureSetup textureSetup;
    private float uCenter;
    private float uRight;
    private float vMiddle;
    private float vBottom;

    @Override
    public void processProperties(IThemeAccessor accessor) {
        this.textColor = Mth.clamp((int)this.textColor, (int)0, (int)0xFFFFFF);
        this.regionTop = Mth.clamp((int)this.regionTop, (int)0, (int)this.textureHeight);
        this.regionBottom = Mth.clamp((int)this.regionBottom, (int)0, (int)(this.textureHeight - this.regionTop));
        this.regionLeft = Mth.clamp((int)this.regionLeft, (int)0, (int)this.textureWidth);
        this.regionRight = Mth.clamp((int)this.regionRight, (int)0, (int)(this.textureWidth - this.regionLeft));
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (this.useResourcePack) {
            AbstractTexture texture = textureManager.getTexture(Identifier.parse((String)this.texture));
            this.textureSetup = TextureSetup.singleTexture((GpuTextureView)texture.getTextureView(), (GpuSampler)texture.getSampler());
        } else {
            AbstractTexture texture;
            try {
                NativeImage image = NativeImage.read((InputStream)Files.newInputStream(accessor.getPath(this.texture), new OpenOption[0]));
                texture = new DynamicTexture(() -> "WTHIT NinePatchTheme", image);
                this.textureSetup = TextureSetup.singleTexture((GpuTextureView)texture.getTextureView(), (GpuSampler)texture.getSampler());
            }
            catch (Exception e) {
                texture = textureManager.getTexture(TextureManager.INTENTIONAL_MISSING_TEXTURE);
                this.textureSetup = TextureSetup.singleTexture((GpuTextureView)texture.getTextureView(), (GpuSampler)texture.getSampler());
            }
        }
        float tw = this.textureWidth;
        float th = this.textureHeight;
        this.uCenter = (float)this.regionLeft / tw;
        this.uRight = (tw - (float)this.regionRight) / tw;
        this.vMiddle = (float)this.regionTop / th;
        this.vBottom = (th - (float)this.regionBottom) / th;
    }

    @Override
    public int getDefaultTextColor() {
        return this.textColor;
    }

    @Override
    public void setPadding(ITheme.Padding padding) {
        padding.set(this.regionTop, this.regionRight, this.regionBottom, this.regionLeft);
    }

    @Override
    public void renderTooltipBackground(GuiGraphics ctx, int x, int y, int width, int height, @Range(from=0L, to=255L) int alpha, DeltaTracker delta) {
        WRenders.state(ctx).submitGuiElement((GuiElementRenderState)new RenderState(alpha, new Matrix3x2f((Matrix3x2fc)ctx.pose()), new ScreenRectangle(x, y, width, height)));
    }

    private class RenderState
    implements GuiElementRenderState {
        final int alpha;
        final Matrix3x2f matrix;
        final ScreenRectangle bounds;

        private RenderState(int alpha, Matrix3x2f matrix, ScreenRectangle bounds) {
            this.alpha = alpha;
            this.matrix = matrix;
            this.bounds = bounds;
        }

        public @Nullable ScreenRectangle bounds() {
            return this.bounds;
        }

        public void buildVertices(VertexConsumer buf) {
            int x = this.bounds.left();
            int y = this.bounds.top();
            int width = this.bounds.width();
            int height = this.bounds.height();
            this.patch(buf, this.matrix, x, y, NinePatchTheme.this.regionLeft, NinePatchTheme.this.regionTop, 0.0f, NinePatchTheme.this.uCenter, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
            this.patch(buf, this.matrix, x + width, y, -NinePatchTheme.this.regionRight, NinePatchTheme.this.regionTop, NinePatchTheme.this.uRight, 1.0f, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
            this.patch(buf, this.matrix, x, y + height, NinePatchTheme.this.regionLeft, -NinePatchTheme.this.regionBottom, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
            this.patch(buf, this.matrix, x + width, y + height, -NinePatchTheme.this.regionRight, -NinePatchTheme.this.regionBottom, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
            int centerX = x + NinePatchTheme.this.regionLeft;
            int centerY = y + NinePatchTheme.this.regionTop;
            int centerWidth = width - (NinePatchTheme.this.regionLeft + NinePatchTheme.this.regionRight);
            int centerHeight = height - (NinePatchTheme.this.regionTop + NinePatchTheme.this.regionBottom);
            block0 : switch (NinePatchTheme.this.mode.ordinal()) {
                case 0: {
                    int regionCenter = NinePatchTheme.this.textureWidth - (NinePatchTheme.this.regionLeft + NinePatchTheme.this.regionRight);
                    int regionMiddle = NinePatchTheme.this.textureHeight - (NinePatchTheme.this.regionTop + NinePatchTheme.this.regionBottom);
                    int maxX = Math.max(x + width - NinePatchTheme.this.regionRight, 0);
                    int maxY = Math.max(y + height - NinePatchTheme.this.regionBottom, 0);
                    for (int cx = centerX; cx < maxX; cx += regionCenter) {
                        int clampedCenter = Math.min(regionCenter, maxX - cx);
                        float uCenter1 = (float)(NinePatchTheme.this.regionLeft + clampedCenter) / (float)NinePatchTheme.this.textureWidth;
                        this.patch(buf, this.matrix, cx, y, clampedCenter, NinePatchTheme.this.regionTop, NinePatchTheme.this.uCenter, uCenter1, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
                        this.patch(buf, this.matrix, cx, maxY, clampedCenter, NinePatchTheme.this.regionBottom, NinePatchTheme.this.uCenter, uCenter1, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
                        for (int cy = centerY; cy < maxY; cy += regionMiddle) {
                            int clampedMiddle = Math.min(regionMiddle, maxY - cy);
                            float vMiddle1 = (float)(NinePatchTheme.this.regionTop + clampedMiddle) / (float)NinePatchTheme.this.textureWidth;
                            if (cx == centerX) {
                                this.patch(buf, this.matrix, x, cy, NinePatchTheme.this.regionLeft, clampedMiddle, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                                this.patch(buf, this.matrix, centerX + centerWidth, cy, NinePatchTheme.this.regionRight, clampedMiddle, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                            }
                            this.patch(buf, this.matrix, cx, cy, clampedCenter, clampedMiddle, NinePatchTheme.this.uCenter, uCenter1, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                            if (regionMiddle <= 0) break;
                        }
                        if (regionCenter <= 0) break block0;
                    }
                    break;
                }
                case 1: {
                    this.patch(buf, this.matrix, centerX, y, centerWidth, NinePatchTheme.this.regionTop, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
                    this.patch(buf, this.matrix, x, centerY, NinePatchTheme.this.regionLeft, centerHeight, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX, centerY, centerWidth, centerHeight, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX + centerWidth, centerY, NinePatchTheme.this.regionRight, centerHeight, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX, centerY + centerHeight, centerWidth, NinePatchTheme.this.regionBottom, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
                }
            }
        }

        private void patch(VertexConsumer buf, Matrix3x2f matrix, int x0, int y0, int w, int h, float u0, float u1, float v0, float v1, int alpha) {
            if (w == 0 || h == 0) {
                return;
            }
            int x1 = x0 + w;
            int y1 = y0 + h;
            if (x1 < x0) {
                int x0r = x0;
                x0 = x1;
                x1 = x0r;
            }
            if (y1 < y0) {
                int y0r = y0;
                y0 = y1;
                y1 = y0r;
            }
            buf.addVertexWith2DPose((Matrix3x2fc)matrix, (float)x0, (float)y1).setUv(u0, v1).setColor(255, 255, 255, alpha);
            buf.addVertexWith2DPose((Matrix3x2fc)matrix, (float)x1, (float)y1).setUv(u1, v1).setColor(255, 255, 255, alpha);
            buf.addVertexWith2DPose((Matrix3x2fc)matrix, (float)x1, (float)y0).setUv(u1, v0).setColor(255, 255, 255, alpha);
            buf.addVertexWith2DPose((Matrix3x2fc)matrix, (float)x0, (float)y0).setUv(u0, v0).setColor(255, 255, 255, alpha);
        }

        public RenderPipeline pipeline() {
            return RenderPipelines.GUI_TEXTURED;
        }

        public TextureSetup textureSetup() {
            return NinePatchTheme.this.textureSetup;
        }

        public @Nullable ScreenRectangle scissorArea() {
            return null;
        }
    }

    public static enum Mode {
        TILE,
        STRETCH;

    }
}

