/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.provider;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.component.GrowingComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.harvest.component.ToolComponent;
import mcp.mobius.waila.plugin.harvest.config.HarvestDisplayMode;
import mcp.mobius.waila.plugin.harvest.config.Options;
import mcp.mobius.waila.plugin.harvest.tool.ToolTier;
import mcp.mobius.waila.plugin.harvest.tool.ToolType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public enum HarvestProvider implements IBlockComponentProvider,
IEventListener
{
    INSTANCE;

    private static final Identifier CLASSIC_HARVESTABLE;
    private static final Identifier CLASSIC_EFFECTIVE_TOOL;
    private static final Identifier CLASSIC_LEVEL;
    private static final Identifier CLASSIC_MINIMAL;
    private static final ToolType UNBREAKABLE;
    public final Map<BlockState, List<ToolType>> toolsCache = new Reference2ObjectOpenHashMap();
    public final Map<BlockState, ToolTier> tierCache = new Reference2ObjectOpenHashMap();
    private int updateId = 0;
    private BlockState state;
    private final List<ToolComponent> toolComponents = new ArrayList<ToolComponent>();
    private boolean renderComponents = false;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        HarvestDisplayMode harvestDisplayMode;
        ToolTier highestTier;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        if (accessor.getPlayer().isCreative() && !config.getBoolean(Options.CREATIVE)) {
            return;
        }
        if (IApiService.INSTANCE.isDevEnv() && config.getBoolean(Options.DEV_DISABLE_CACHE)) {
            this.toolsCache.clear();
            this.tierCache.clear();
        }
        this.updateId = accessor.getUpdateId();
        this.state = accessor.getBlockState();
        boolean unbreakable = this.state.getDestroySpeed((BlockGetter)accessor.getWorld(), accessor.getPosition()) < 0.0f;
        List<ToolType> tools = this.toolsCache.get(this.state);
        if (tools == null) {
            tools = new ArrayList<ToolType>();
            if (unbreakable) {
                tools.add(UNBREAKABLE);
            } else {
                for (ToolType toolType : ToolType.all()) {
                    if (!toolType.blockPredicate.test(this.state)) continue;
                    tools.add(toolType);
                }
                if (tools.isEmpty()) {
                    tools = List.of();
                }
            }
            this.toolsCache.put(this.state, tools);
        }
        if ((highestTier = this.tierCache.get(this.state)) == null) {
            highestTier = ToolTier.NONE;
            for (ToolTier tier : ToolTier.all()) {
                if (this.state.is(tier.incorrect)) continue;
                highestTier = tier;
                break;
            }
            this.tierCache.put(this.state, highestTier);
        }
        if ((harvestDisplayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE))) == HarvestDisplayMode.MODERN) {
            return;
        }
        ItemStack heldStack = accessor.getPlayer().getInventory().getSelectedItem();
        if (harvestDisplayMode == HarvestDisplayMode.CLASSIC) {
            tooltip.setLine(CLASSIC_HARVESTABLE, (Component)Component.empty().append((Component)this.getHarvestableSymbol(accessor, unbreakable)).append(" ").append((Component)Component.translatable((String)"tooltip.waila.harvest.harvestable")));
            if (!tools.isEmpty() && !unbreakable) {
                tooltip.setLine(CLASSIC_EFFECTIVE_TOOL, new PairComponent((Component)Component.translatable((String)"tooltip.waila.harvest.effective_tool"), (Component)HarvestProvider.getToolText(tools, heldStack)));
            }
            if (highestTier != ToolTier.NONE) {
                tooltip.setLine(CLASSIC_LEVEL, new PairComponent((Component)Component.translatable((String)"tooltip.waila.harvest.level"), (Component)HarvestProvider.getTierText(highestTier, heldStack)));
            }
        } else if (harvestDisplayMode == HarvestDisplayMode.CLASSIC_MINIMAL) {
            MutableComponent text = Component.empty();
            text.append((Component)this.getHarvestableSymbol(accessor, unbreakable));
            if (!tools.isEmpty() && !unbreakable) {
                text.append(" | ").append((Component)HarvestProvider.getToolText(tools, heldStack));
                if (highestTier != ToolTier.NONE) {
                    text.append(" | ");
                }
            }
            if (highestTier != ToolTier.NONE) {
                text.append((Component)HarvestProvider.getTierText(highestTier, heldStack));
            }
            tooltip.setLine(CLASSIC_MINIMAL, (Component)text);
        }
    }

    @Override
    public void onHandleTooltip(ITooltip tooltip, ICommonAccessor accessor, IPluginConfig config) {
        this.renderComponents = false;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        HarvestDisplayMode displayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE));
        if (displayMode != HarvestDisplayMode.MODERN) {
            return;
        }
        if (this.updateId != accessor.getUpdateId()) {
            return;
        }
        List<ToolType> tools = this.toolsCache.get(this.state);
        ToolTier highestTier = this.tierCache.get(this.state);
        if (tools == null || highestTier == null || tools.isEmpty()) {
            return;
        }
        ItemStack heldStack = accessor.getPlayer().getInventory().getSelectedItem();
        ITooltipLine line = tooltip.getLine(tooltip.getLineCount() - 1);
        line.with(GrowingComponent.INSTANCE);
        this.toolComponents.clear();
        for (ToolType tool : tools) {
            ToolComponent component;
            if (tool == UNBREAKABLE) {
                component = new ToolComponent(null, false);
            } else {
                ItemStack icon = tool.getIcon(highestTier);
                Boolean matches = null;
                if (this.state.requiresCorrectToolForDrops()) {
                    matches = tool.itemPredicate.test(heldStack);
                    if (highestTier != ToolTier.NONE) {
                        ToolTier heldTier = ToolTier.get(heldStack);
                        matches = matches != false && heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier);
                    }
                }
                component = new ToolComponent(icon, matches);
            }
            line.with(component);
            this.toolComponents.add(component);
        }
        this.renderComponents = true;
    }

    @Override
    public void onAfterTooltipRender(GuiGraphics ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        if (!this.renderComponents) {
            return;
        }
        for (ToolComponent component : this.toolComponents) {
            component.actuallyRender(ctx, rect.y + rect.height - 13);
        }
    }

    private MutableComponent getHarvestableSymbol(IBlockAccessor accessor, boolean unbreakable) {
        return unbreakable || !accessor.getPlayer().hasCorrectToolForDrops(this.state) ? Component.literal((String)"\u2718").withStyle(ChatFormatting.RED) : Component.literal((String)"\u2714").withStyle(ChatFormatting.GREEN);
    }

    private static MutableComponent getToolText(List<ToolType> tools, ItemStack heldStack) {
        MutableComponent toolText = Component.empty();
        Iterator<ToolType> toolIter = tools.iterator();
        while (toolIter.hasNext()) {
            ToolType tool = toolIter.next();
            if (tool == UNBREAKABLE) continue;
            toolText.append((Component)tool.text.copy().withStyle(tool.itemPredicate.test(heldStack) ? ChatFormatting.GREEN : ChatFormatting.RED));
            if (!toolIter.hasNext()) continue;
            toolText.append(", ");
        }
        return toolText;
    }

    private static MutableComponent getTierText(ToolTier highestTier, ItemStack heldStack) {
        MutableComponent tierText = I18n.exists((String)highestTier.tlKey()) ? Component.translatable((String)highestTier.tlKey()) : Component.literal((String)String.valueOf(highestTier.index));
        ToolTier heldTier = ToolTier.get(heldStack);
        tierText.withStyle(heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier) ? ChatFormatting.GREEN : ChatFormatting.RED);
        return tierText;
    }

    static {
        CLASSIC_HARVESTABLE = Options.rl("classic.harvestable");
        CLASSIC_EFFECTIVE_TOOL = Options.rl("classic.effective_tool");
        CLASSIC_LEVEL = Options.rl("classic.level");
        CLASSIC_MINIMAL = Options.rl("classic.minimal");
        UNBREAKABLE = new ToolType();
    }
}

