/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.jspecify.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<Identifier, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> Map.of(ToolMaterial.WOOD.incorrectBlocksForDrops().location(), "wood", ToolMaterial.STONE.incorrectBlocksForDrops().location(), "stone", ToolMaterial.IRON.incorrectBlocksForDrops().location(), "iron", ToolMaterial.DIAMOND.incorrectBlocksForDrops().location(), "diamond", ToolMaterial.GOLD.incorrectBlocksForDrops().location(), "gold", ToolMaterial.NETHERITE.incorrectBlocksForDrops().location(), "netherite"));
    private static Supplier<Map<Identifier, ToolTier>> tiers;
    public final ToolMaterial tier;
    public final int index;
    public final TagKey<Block> incorrect;
    private final Supplier<String> tlKey;

    public ToolTier(ToolMaterial tier, int index) {
        this.tier = tier;
        this.index = index;
        this.incorrect = tier.incorrectBlocksForDrops();
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla = VANILLA_TIER_TL_KEYS.get().get(this.incorrect.location());
            String key = vanilla != null ? vanilla : this.incorrect.location().toLanguageKey();
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static void resetMap() {
        tiers = Suppliers.memoize(() -> {
            LinkedHashMap<Identifier, ToolTier> map = new LinkedHashMap<Identifier, ToolTier>();
            int index = 0;
            for (ToolMaterial tier : IApiService.INSTANCE.getTiers()) {
                Identifier key = tier.incorrectBlocksForDrops().location();
                if (map.containsKey(key)) continue;
                map.put(key, new ToolTier(tier, index++));
            }
            return map;
        });
    }

    public static Collection<ToolTier> all() {
        return tiers.get().values();
    }

    public static @Nullable ToolTier get(ItemStack stack) {
        Tool stackTool = (Tool)stack.get(DataComponents.TOOL);
        if (stackTool == null) {
            return null;
        }
        for (Tool.Rule toolRule : stackTool.rules()) {
            HolderSet holderSet;
            Boolean correctForDrops = toolRule.correctForDrops().orElse(null);
            if (correctForDrops != Boolean.FALSE || !((holderSet = toolRule.blocks()) instanceof HolderSet.Named)) continue;
            HolderSet.Named named = (HolderSet.Named)holderSet;
            return tiers.get().get(named.key().location());
        }
        return null;
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        return this.incorrect.location().equals((Object)other.incorrect.location());
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }

    static {
        ToolTier.resetMap();
    }
}

