/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.test;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public enum ComplexDataTest implements IBlockComponentProvider,
IDataProvider<ChestBlockEntity>
{
    INSTANCE;

    public static final Identifier ENABLED;
    public static final Identifier BLOCK;
    public static final Identifier MULTIPLE_ADDITION;
    public static final IData.Type<Data> DATA;
    public static final StreamCodec<RegistryFriendlyByteBuf, Data> DATA_CODEC;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        Data data = accessor.getData().get(DATA);
        if (data != null) {
            tooltip.addLine(new PairComponent((Component)Component.literal((String)"data"), (Component)Component.literal((String)data.value)));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<ChestBlockEntity> accessor, IPluginConfig config) {
        if (!config.getBoolean(ENABLED)) {
            return;
        }
        if (config.getBoolean(MULTIPLE_ADDITION)) {
            data.add(DATA, result -> {
                result.add(new Data("one"));
                try {
                    result.add(new Data("two"));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        if (config.getBoolean(BLOCK)) {
            data.add(DATA, IDataWriter.Result::block);
        }
        data.add(DATA, ctx -> ctx.add(new Data("moe moe kyun")));
    }

    static {
        ENABLED = Identifier.parse((String)"test:data.complex");
        BLOCK = Identifier.parse((String)"test:data.complex.block");
        MULTIPLE_ADDITION = Identifier.parse((String)"test:data.complex.multiple_addition");
        DATA = IData.createType(ENABLED);
        DATA_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Data::value, Data::new);
    }

    public record Data(String value) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return DATA;
        }
    }
}

