/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixed.MMultiPlayerGameMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    static final int FADE_TICK = 3;
    boolean wasBreaking = false;
    float targetProgress = 0.0f;
    float lastProgress = 0.0f;
    boolean fadeFinish = false;
    int fadeTicks = 0;
    float fade = 0.0f;

    @Override
    public void onTick(IPluginConfig config) {
        boolean isBreaking;
        this.targetProgress = 0.0f;
        if (this.fadeFinish) {
            this.fade = 0.0f;
            this.lastProgress = 0.0f;
            this.fadeFinish = false;
        }
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        MMultiPlayerGameMode gameMode = (MMultiPlayerGameMode)Objects.requireNonNull(Minecraft.getInstance().gameMode);
        this.targetProgress = gameMode.wthit_destroyProgress();
        boolean bl = isBreaking = this.targetProgress > 0.0f;
        if (this.wasBreaking && !isBreaking) {
            this.fadeTicks = 3;
            this.fade = this.fadeTicks;
            if (gameMode.wthit_wasDestroyed()) {
                this.targetProgress = 1.0f;
            }
        }
        this.wasBreaking = isBreaking;
        if (this.fadeTicks > 0) {
            --this.fadeTicks;
            if (this.fadeTicks == 0) {
                this.fadeFinish = true;
            }
        }
    }

    @Override
    public void onAfterTooltipRender(GuiGraphics ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        float lineLength;
        float dt = Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks();
        float progress = this.lastProgress;
        if (this.targetProgress > this.lastProgress) {
            float progressChange = (this.targetProgress - this.lastProgress) * dt;
            progress = Mth.clamp((float)(this.lastProgress + progressChange), (float)0.0f, (float)1.0f);
        }
        this.lastProgress = progress;
        if (progress <= 0.0f && this.fade <= 0.0f) {
            return;
        }
        boolean bottomOnly = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY);
        float f = lineLength = bottomOnly ? (float)(rect.width - 2) * progress : (float)((rect.width - 2 + (rect.height - 2)) * 2) * progress;
        if (lineLength >= 1.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            float alpha = this.fade > 0.0f ? this.fade / 3.0f : 1.0f;
            int a = (int)(alpha * (float)(color >> 24 & 0xFF));
            color = color & 0xFFFFFF | a << 24;
            ctx.hLine(x, x + Math.round(Math.min(lineLength, (float)hLength)) - 1, y, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                ctx.vLine(x, y, y - Math.round(Math.min(lineLength, (float)vLength)) - 1, color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 2;
                    y = rect.y + 1;
                    ctx.hLine(x, x - Math.round(Math.min(lineLength, (float)hLength)) + 1, y, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 1;
                        ctx.vLine(x, y, y + Math.round(Math.min(lineLength, (float)vLength)) + 1, color);
                    }
                }
            }
        }
        if (this.fade > 0.0f) {
            this.fade = Math.max(this.fade - dt, 0.0f);
        }
    }
}

