/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import java.util.HashSet;
import java.util.Set;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.util.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jspecify.annotations.Nullable;

public final class ExceptionUtil {
    private static final Log LOG = Log.create();
    private static final Set<String> ERRORS = new HashSet<String>();

    public static boolean dump(Throwable e, String errorName, @Nullable ITooltip tooltip) {
        boolean log = ERRORS.add(errorName);
        if (log) {
            LOG.error("Caught unhandled exception : [{}] {}", (Object)errorName, (Object)e);
            LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (tooltip != null) {
            tooltip.setLine(WailaConstants.ERROR_TAG, (Component)Component.literal((String)("Error on " + errorName + "\nSee logs for more info")).withStyle(ChatFormatting.RED));
        }
        return log;
    }
}

