/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.MapProcessor;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.drawing.DrawingHighlightCacheDimensionHandler;
import xaeroplus.feature.drawing.DrawingLinesCacheDimensionHandler;
import xaeroplus.feature.drawing.DrawingTextCacheDimensionHandler;
import xaeroplus.feature.drawing.db.DrawingDatabase;
import xaeroplus.feature.render.line.Line;
import xaeroplus.feature.render.text.Text;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;
import xaeroplus.util.timer.Timer;
import xaeroplus.util.timer.Timers;

public class DrawingCache
implements Closeable {
    private DrawingDatabase database;
    private String currentWorldId;
    private final AtomicBoolean cacheReady = new AtomicBoolean(false);
    private final String databaseName;
    private ListeningExecutorService dbExecutor;
    private final ListeningExecutorService parentExecutor;
    private final Map<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> highlightsCacheMap = new ConcurrentHashMap<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler>(3);
    private final Map<ResourceKey<Level>, DrawingLinesCacheDimensionHandler> linesCacheMap = new ConcurrentHashMap<ResourceKey<Level>, DrawingLinesCacheDimensionHandler>(3);
    private final Map<ResourceKey<Level>, DrawingTextCacheDimensionHandler> textsCacheMap = new ConcurrentHashMap<ResourceKey<Level>, DrawingTextCacheDimensionHandler>(3);
    private final Queue<Runnable> initializeTaskQueue = new ConcurrentLinkedQueue<Runnable>();
    Minecraft mc = Minecraft.getInstance();
    final Timer tickTimer = Timers.tickTimer();
    final Timer flushTimer = Timers.tickTimer();

    public DrawingCache(String databaseName) {
        this.databaseName = databaseName;
        this.parentExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(databaseName + "-Manager").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception in {}", (Object)t.getName(), (Object)e)).build()));
    }

    public void addHighlight(int x, int z, int color, ResourceKey<Level> dimension) {
        try {
            DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getHighlightCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addHighlight(x, z, color, dimension));
                return;
            }
            cacheForActualDimension.addHighlight(x, z, color);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding highlight to {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    public void addLine(Line line, int color, ResourceKey<Level> dimension) {
        try {
            DrawingLinesCacheDimensionHandler cacheForActualDimension = this.getLinesCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addLine(line, color, dimension));
                return;
            }
            cacheForActualDimension.addLine(line, color);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding line to {} disk cache: {}, {}", new Object[]{this.databaseName, line, e});
        }
    }

    public void addText(Text text, ResourceKey<Level> dimension) {
        if (text.value().isBlank()) {
            return;
        }
        try {
            DrawingTextCacheDimensionHandler cacheForActualDimension = this.getTextCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addText(text, dimension));
                return;
            }
            cacheForActualDimension.addText(text);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding text to {} disk cache: {}, {}", new Object[]{this.databaseName, text, e});
        }
    }

    public void removeHighlight(int x, int z, ResourceKey<Level> dimension) {
        try {
            DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getHighlightCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeHighlight(x, z, dimension));
                return;
            }
            cacheForActualDimension.removeHighlight(x, z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing highlight from {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    public void removeLine(Line line, ResourceKey<Level> dimension) {
        try {
            DrawingLinesCacheDimensionHandler cacheForActualDimension = this.getLinesCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeLine(line, dimension));
                return;
            }
            cacheForActualDimension.removeLine(line);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing line from {} disk cache: {}, {}", new Object[]{this.databaseName, line, e});
        }
    }

    public void removeText(int x, int z, ResourceKey<Level> dimension) {
        try {
            DrawingTextCacheDimensionHandler cacheForActualDimension = this.getTextCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeText(x, z, dimension));
                return;
            }
            cacheForActualDimension.removeText(x, z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing text from {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    public Long2LongMap getHighlights(ResourceKey<Level> dimensionId) {
        if (dimensionId == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        DrawingHighlightCacheDimensionHandler cacheForDimension = this.getHighlightCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        return cacheForDimension.getCacheMap(dimensionId);
    }

    public Object2IntMap<Line> getLines(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return Object2IntMaps.emptyMap();
        }
        DrawingLinesCacheDimensionHandler cacheForDimension = this.getLinesCacheForDimension(dimension, false);
        if (cacheForDimension == null) {
            return Object2IntMaps.emptyMap();
        }
        return cacheForDimension.getLines();
    }

    public Long2ObjectMap<Text> getTexts(ResourceKey<Level> dimensionId) {
        if (dimensionId == null) {
            return Long2ObjectMaps.emptyMap();
        }
        DrawingTextCacheDimensionHandler cacheForDimension = this.getTextCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return Long2ObjectMaps.emptyMap();
        }
        return cacheForDimension.getTexts();
    }

    public void handleWorldChange(XaeroWorldChangeEvent event) {
        this.parentExecutor.execute(() -> {
            switch (event.worldChangeType()) {
                case ENTER_WORLD: {
                    if (!this.cacheReady.get()) {
                        if (!this.initializeWorld()) break;
                        this.cacheReady.set(true);
                        this.submitTickTask(() -> {
                            this.loadHighlightsInViewedDimension();
                            this.loadLinesInViewedDimension();
                            this.loadTextsInViewedDimension();
                        });
                        break;
                    }
                    XaeroPlus.LOGGER.warn("[{}] Entered world when cache was already initialized", (Object)this.databaseName);
                    break;
                }
                case EXIT_WORLD: {
                    if (this.cacheReady.compareAndSet(true, false)) {
                        try {
                            ArrayList tasks = new ArrayList();
                            tasks.addAll(this.flushAllChunks());
                            tasks.addAll(this.flushAllLines());
                            tasks.addAll(this.flushAllTexts());
                            CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            XaeroPlus.LOGGER.error("Error saving all chunks before world change", (Throwable)e);
                        }
                    } else {
                        XaeroPlus.LOGGER.warn("[{}] Exited world when cache was already uninitialized", (Object)this.databaseName);
                    }
                    this.reset();
                    break;
                }
                case VIEWED_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadHighlightsInViewedDimension);
                    this.submitTickTask(this::loadLinesInViewedDimension);
                    this.submitTickTask(this::loadTextsInViewedDimension);
                    break;
                }
                case ACTUAL_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadChunksOnActualDimensionSwitch);
                    this.submitTickTask(this::loadLinesOnActualDimensionSwitch);
                    this.submitTickTask(this::loadTextsOnActualDimensionSwitch);
                }
            }
        });
    }

    private CompletableFuture<?> submitTickTask(Runnable runnable) {
        return TickTaskExecutor.INSTANCE.submit(runnable);
    }

    private synchronized void reset() {
        this.currentWorldId = null;
        if (this.dbExecutor != null) {
            ListenableFuture closeFuture = this.dbExecutor.submit(() -> {
                if (this.database != null) {
                    this.database.close();
                }
            });
            try {
                this.dbExecutor.shutdown();
                closeFuture.get(3L, TimeUnit.SECONDS);
                this.dbExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Timed out waiting for {} executor to shutdown", (Object)this.databaseName, (Object)e);
            }
        }
        if (this.database != null) {
            this.database.close();
        }
        this.highlightsCacheMap.clear();
        this.linesCacheMap.clear();
        this.textsCacheMap.clear();
        this.database = null;
        this.initializeTaskQueue.clear();
    }

    private List<CompletableFuture<?>> flushAllChunks() {
        return this.getAllHighlightCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleHighlightsToDatabase)).collect(Collectors.toList());
    }

    private List<CompletableFuture<?>> flushAllLines() {
        return this.getAllLinesCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleLinesToDatabase)).collect(Collectors.toList());
    }

    private List<CompletableFuture<?>> flushAllTexts() {
        return this.getAllTextsCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleTextsToDatabase)).collect(Collectors.toList());
    }

    public DrawingHighlightCacheDimensionHandler getHighlightCacheForActualDimension() {
        if (!this.cacheReady.get()) {
            return null;
        }
        return this.getHighlightCacheForDimension(ChunkUtils.getActualDimension(), true);
    }

    public DrawingTextCacheDimensionHandler getTextCacheForActualDimension() {
        if (!this.cacheReady.get()) {
            return null;
        }
        return this.getTextCacheForDimension(ChunkUtils.getActualDimension(), true);
    }

    private DrawingHighlightCacheDimensionHandler initializeHighlightDimensionCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        DrawingDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.identifier(), db, executor});
            return null;
        }
        DrawingHighlightCacheDimensionHandler cacheHandler = new DrawingHighlightCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.highlightsCacheMap.put(dimension, cacheHandler);
        return cacheHandler;
    }

    private DrawingLinesCacheDimensionHandler initializeLinesCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        DrawingDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk lines cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.identifier(), db, executor});
            return null;
        }
        DrawingLinesCacheDimensionHandler linesCacheHandler = new DrawingLinesCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.linesCacheMap.put(dimension, linesCacheHandler);
        return linesCacheHandler;
    }

    private DrawingTextCacheDimensionHandler initializeTextDimensionCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        DrawingDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.identifier(), db, executor});
            return null;
        }
        DrawingTextCacheDimensionHandler cacheHandler = new DrawingTextCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.textsCacheMap.put(dimension, cacheHandler);
        return cacheHandler;
    }

    public DrawingHighlightCacheDimensionHandler getHighlightCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        DrawingHighlightCacheDimensionHandler dimensionCache = this.highlightsCacheMap.get(dimension);
        if (dimensionCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk cache for dimension: {}", (Object)this.databaseName, (Object)dimension.identifier());
            dimensionCache = this.initializeHighlightDimensionCacheHandler(dimension);
        }
        return dimensionCache;
    }

    public DrawingTextCacheDimensionHandler getTextCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        DrawingTextCacheDimensionHandler dimensionCache = this.textsCacheMap.get(dimension);
        if (dimensionCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk cache for dimension: {}", (Object)this.databaseName, (Object)dimension.identifier());
            dimensionCache = this.initializeTextDimensionCacheHandler(dimension);
        }
        return dimensionCache;
    }

    public DrawingLinesCacheDimensionHandler getLinesCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        DrawingLinesCacheDimensionHandler linesCache = this.linesCacheMap.get(dimension);
        if (linesCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk lines cache for dimension: {}", (Object)this.databaseName, (Object)dimension.identifier());
            linesCache = this.initializeLinesCacheHandler(dimension);
        }
        return linesCache;
    }

    public List<DrawingHighlightCacheDimensionHandler> getAllHighlightCaches() {
        return List.copyOf(this.highlightsCacheMap.values());
    }

    public List<DrawingLinesCacheDimensionHandler> getAllLinesCaches() {
        return List.copyOf(this.linesCacheMap.values());
    }

    public List<DrawingTextCacheDimensionHandler> getAllTextsCaches() {
        return List.copyOf(this.textsCacheMap.values());
    }

    public List<DrawingHighlightCacheDimensionHandler> getHighlightCachesExceptDimension(ResourceKey<Level> dimension) {
        ArrayList<DrawingHighlightCacheDimensionHandler> caches = new ArrayList<DrawingHighlightCacheDimensionHandler>(this.highlightsCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> entry : this.highlightsCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingHighlightCacheDimensionHandler> getHighlightCachesExceptDimensions(List<ResourceKey<Level>> dimensions) {
        ArrayList<DrawingHighlightCacheDimensionHandler> caches = new ArrayList<DrawingHighlightCacheDimensionHandler>(this.highlightsCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> entry : this.highlightsCacheMap.entrySet()) {
            if (dimensions.contains(entry.getKey())) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingTextCacheDimensionHandler> getTextCachesExceptDimension(ResourceKey<Level> dimension) {
        ArrayList<DrawingTextCacheDimensionHandler> caches = new ArrayList<DrawingTextCacheDimensionHandler>(this.textsCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingTextCacheDimensionHandler> entry : this.textsCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingTextCacheDimensionHandler> getTextCachesExceptDimensions(List<ResourceKey<Level>> dimensions) {
        ArrayList<DrawingTextCacheDimensionHandler> caches = new ArrayList<DrawingTextCacheDimensionHandler>(this.textsCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingTextCacheDimensionHandler> entry : this.textsCacheMap.entrySet()) {
            if (dimensions.contains(entry.getKey())) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingLinesCacheDimensionHandler> getLineCachesExceptDimension(ResourceKey<Level> dimension) {
        ArrayList<DrawingLinesCacheDimensionHandler> caches = new ArrayList<DrawingLinesCacheDimensionHandler>(this.linesCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingLinesCacheDimensionHandler> entry : this.linesCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingLinesCacheDimensionHandler> getLineCachesExceptDimensions(List<ResourceKey<Level>> dimensions) {
        ArrayList<DrawingLinesCacheDimensionHandler> caches = new ArrayList<DrawingLinesCacheDimensionHandler>(this.linesCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingLinesCacheDimensionHandler> entry : this.linesCacheMap.entrySet()) {
            if (dimensions.contains(entry.getKey())) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    private synchronized boolean initializeWorld() {
        try {
            MapProcessor mapProcessor = XaeroWorldMapCore.currentSession.getMapProcessor();
            if (mapProcessor == null) {
                return false;
            }
            String worldId = mapProcessor.getCurrentWorldId();
            if (worldId == null) {
                return false;
            }
            this.currentWorldId = worldId;
            this.dbExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.databaseName + "-Worker").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception handler in {}", (Object)t.getName(), (Object)e)).build()));
            this.database = new DrawingDatabase(worldId, this.databaseName);
            this.initializeHighlightDimensionCacheHandler((ResourceKey<Level>)Level.OVERWORLD);
            this.initializeHighlightDimensionCacheHandler((ResourceKey<Level>)Level.NETHER);
            this.initializeHighlightDimensionCacheHandler((ResourceKey<Level>)Level.END);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.OVERWORLD);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.NETHER);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.END);
            this.initializeTextDimensionCacheHandler((ResourceKey<Level>)Level.OVERWORLD);
            this.initializeTextDimensionCacheHandler((ResourceKey<Level>)Level.NETHER);
            this.initializeTextDimensionCacheHandler((ResourceKey<Level>)Level.END);
            if (!this.initializeTaskQueue.isEmpty()) {
                XaeroPlus.LOGGER.info("[{}] Running {} queued tasks", (Object)this.databaseName, (Object)this.initializeTaskQueue.size());
            }
            while (!this.initializeTaskQueue.isEmpty()) {
                this.submitTickTask(this.initializeTaskQueue.poll());
            }
            return true;
        }
        catch (Exception e2) {
            this.reset();
            return false;
        }
    }

    private void loadChunksOnActualDimensionSwitch() {
        DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getHighlightCacheForActualDimension();
        if (cacheForActualDimension == null) {
            return;
        }
        cacheForActualDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    private void loadLinesOnActualDimensionSwitch() {
        DrawingLinesCacheDimensionHandler linesCacheForActualDimension = this.getLinesCacheForDimension(ChunkUtils.getActualDimension(), true);
        if (linesCacheForActualDimension == null) {
            return;
        }
        linesCacheForActualDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    private void loadTextsOnActualDimensionSwitch() {
        DrawingTextCacheDimensionHandler cacheForActualDimension = this.getTextCacheForActualDimension();
        if (cacheForActualDimension == null) {
            return;
        }
        cacheForActualDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    private void loadHighlightsInViewedDimension() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        DrawingHighlightCacheDimensionHandler cacheForCurrentDimension = this.getHighlightCacheForDimension(viewedDim, true);
        if (cacheForCurrentDimension == null) {
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        cacheForCurrentDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
    }

    private void loadLinesInViewedDimension() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        DrawingLinesCacheDimensionHandler linesCacheForCurrentDimension = this.getLinesCacheForDimension(viewedDim, true);
        if (linesCacheForCurrentDimension == null) {
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        linesCacheForCurrentDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
    }

    private void loadTextsInViewedDimension() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        DrawingTextCacheDimensionHandler cacheForCurrentDimension = this.getTextCacheForDimension(viewedDim, true);
        if (cacheForCurrentDimension == null) {
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        cacheForCurrentDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
    }

    public void onEnable() {
        this.handleWorldChange(new XaeroWorldChangeEvent(XaeroWorldChangeEvent.WorldChangeType.ENTER_WORLD, null, ChunkUtils.getActualDimension()));
    }

    public void onDisable() {
        this.parentExecutor.execute(() -> {
            this.cacheReady.set(false);
            try {
                ArrayList tasks = new ArrayList();
                tasks.addAll(this.flushAllChunks());
                tasks.addAll(this.flushAllLines());
                tasks.addAll(this.flushAllTexts());
                CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error saving all drawing data before disabling", (Throwable)e);
            }
            this.reset();
        });
    }

    public int getMinimapRegionWindowSize() {
        return Math.max(3, Globals.minimapScaleMultiplier);
    }

    public void handleTick() {
        DrawingLinesCacheDimensionHandler lineCacheForDimension;
        DrawingTextCacheDimensionHandler textCacheForDimension;
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        if (!this.cacheReady.get()) {
            return;
        }
        if (XaeroWorldMapCore.currentSession == null) {
            return;
        }
        int jitter = ThreadLocalRandom.current().nextInt(0, 10);
        if (this.flushTimer.tick(600 + jitter)) {
            this.flushAllChunks();
            this.flushAllLines();
            this.flushAllTexts();
        }
        if (!this.tickTimer.tick(10 + jitter)) {
            return;
        }
        ResourceKey<Level> mapDimension = Globals.getCurrentDimensionId();
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        int actualPlayerRegionX = ChunkUtils.actualPlayerRegionX();
        int actualPlayerRegionZ = ChunkUtils.actualPlayerRegionZ();
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        DrawingHighlightCacheDimensionHandler highlightCacheForDimension = this.getHighlightCacheForDimension(mapDimension, true);
        if (highlightCacheForDimension != null) {
            highlightCacheForDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
        }
        if ((textCacheForDimension = this.getTextCacheForDimension(mapDimension, true)) != null) {
            textCacheForDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
        }
        if ((lineCacheForDimension = this.getLinesCacheForDimension(mapDimension, true)) != null) {
            lineCacheForDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
        }
        if (mapDimension == actualDimension) {
            this.getHighlightCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
            this.getTextCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
            this.getLineCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
        } else {
            DrawingLinesCacheDimensionHandler actualDimLinesCache;
            DrawingTextCacheDimensionHandler actualDimTextCache;
            DrawingHighlightCacheDimensionHandler actualDimHighlightCache = this.getHighlightCacheForDimension(actualDimension, true);
            if (actualDimHighlightCache != null) {
                actualDimHighlightCache.setWindow(actualPlayerRegionX, actualPlayerRegionZ, windowSize);
            }
            if ((actualDimTextCache = this.getTextCacheForDimension(actualDimension, true)) != null) {
                actualDimTextCache.setWindow(actualPlayerRegionX, actualPlayerRegionZ, windowSize);
            }
            if ((actualDimLinesCache = this.getLinesCacheForDimension(actualDimension, true)) != null) {
                actualDimLinesCache.setWindow(actualPlayerRegionX, actualPlayerRegionZ, windowSize);
            }
            this.getHighlightCachesExceptDimensions(List.of(mapDimension, actualDimension)).forEach(cache -> cache.setWindow(0, 0, 0));
            this.getTextCachesExceptDimensions(List.of(mapDimension, actualDimension)).forEach(cache -> cache.setWindow(0, 0, 0));
            this.getLineCachesExceptDimensions(List.of(mapDimension, actualDimension)).forEach(cache -> cache.setWindow(0, 0, 0));
        }
    }

    @Override
    public void close() throws IOException {
        this.parentExecutor.shutdown();
    }
}

