/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.extensions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.DrawOrderHelper;

public class DrawOrderScreen
extends Screen {
    static Minecraft mc = Minecraft.getInstance();
    Screen parent;
    DrawFeatureList drawFeatureList;
    List<String> drawFeatureIdOrder;
    int selected;

    public DrawOrderScreen(Screen parent, Screen escapeScreen) {
        super((Component)Component.translatable((String)"xaeroplus.gui.draw_order.title"));
        this.parent = parent;
        this.drawFeatureIdOrder = new ArrayList<String>();
        this.selected = -1;
    }

    public void init() {
        this.drawFeatureIdOrder = this.loadEntries();
        this.drawFeatureList = new DrawFeatureList(this);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), b -> mc.setScreen(this.parent)).bounds(this.width / 2 - 100, this.height - 34, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"xaeroplus.gui.draw_order.reset"), b -> TickTaskExecutor.INSTANCE.execute(() -> {
            Settings.REGISTRY.drawOrderSetting.setValue("");
            this.init(this.width, this.height);
        })).bounds(this.width - 82, 2, 80, 20).build());
        this.addWidget((GuiEventListener)this.drawFeatureList);
        if (!this.drawFeatureIdOrder.isEmpty()) {
            this.selected = 0;
            this.drawFeatureList.setFocused((GuiEventListener)this.drawFeatureList.getFirstElement());
        }
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.drawFeatureList != null) {
            this.drawFeatureList.releaseDrag();
        }
        return super.mouseReleased(event);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawFeatureList.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(DrawOrderScreen.mc.font, this.title, this.width / 2, 5, -1);
        guiGraphics.drawCenteredString(DrawOrderScreen.mc.font, (Component)Component.translatable((String)"xaeroplus.gui.draw_order.subtitle"), this.width / 2, this.height - 52, -1);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public List<String> loadEntries() {
        return DrawOrderHelper.load();
    }

    public void saveEntries(List<String> entries) {
        Settings.REGISTRY.drawOrderSetting.setValue(DrawOrderHelper.serialize(entries));
    }

    public static ScreenSwitchSettingEntry getScreenSwitchSettingEntry() {
        return new ScreenSwitchSettingEntry("Draw Order", DrawOrderScreen::new, null, true);
    }

    public static class DrawFeatureList
    extends ObjectSelectionList<DrawFeatureEntry> {
        boolean dragging;
        int dragStartX;
        int dragStartY;
        int dragged;
        int draggedOffsetX;
        int draggedOffsetY;
        DrawOrderScreen drawOrderScreen;

        public DrawFeatureList(DrawOrderScreen drawOrderScreen) {
            super(mc, drawOrderScreen.width, drawOrderScreen.height - 91, 30, 24);
            this.drawOrderScreen = drawOrderScreen;
            this.dragged = -1;
            this.createEntries().forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            if (drawOrderScreen.selected != -1) {
                this.setFocused((GuiEventListener)this.getEntry(drawOrderScreen.selected));
            }
        }

        public DrawFeatureEntry getEntry(int index) {
            if (index < 0 || index >= this.children().size()) {
                return null;
            }
            return (DrawFeatureEntry)((Object)this.children().get(index));
        }

        public DrawFeatureEntry getFirstElement() {
            return this.getEntry(0);
        }

        public boolean isFocused() {
            return this.drawOrderScreen.getFocused() == this;
        }

        public void setFocused(GuiEventListener guiEventListener) {
            if (guiEventListener instanceof DrawFeatureEntry) {
                DrawFeatureEntry entry = (DrawFeatureEntry)guiEventListener;
                this.drawOrderScreen.selected = entry.index;
            }
            if (guiEventListener == null) {
                this.drawOrderScreen.selected = -1;
            }
            super.setFocused(guiEventListener);
            if (this.getFocused() == null) {
                this.setSelected(null);
            }
        }

        List<DrawFeatureEntry> createEntries() {
            ArrayList<DrawFeatureEntry> entries = new ArrayList<DrawFeatureEntry>();
            for (int i = 0; i < this.drawOrderScreen.drawFeatureIdOrder.size(); ++i) {
                DrawFeatureEntry entry = new DrawFeatureEntry(this.drawOrderScreen, this, i);
                entries.add(entry);
            }
            return entries;
        }

        void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
            this.drawOrderScreen.saveEntries(this.drawOrderScreen.drawFeatureIdOrder);
        }

        public int scrollBarX() {
            return this.width / 2 + 164;
        }

        public int getRowWidth() {
            return 300;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.renderBackdrop(guiGraphics);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                DrawFeatureEntry draggedEntry = this.getEntry(this.dragged);
                draggedEntry.renderEntryText(guiGraphics, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                DrawFeatureEntry hoveredEntry = (DrawFeatureEntry)this.getEntryAtPosition(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = this.drawOrderScreen.drawFeatureIdOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        this.drawOrderScreen.drawFeatureIdOrder.set(i, this.drawOrderScreen.drawFeatureIdOrder.get(i - slideDirection));
                    }
                    this.drawOrderScreen.drawFeatureIdOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setFocused(null);
            }
        }

        public void renderBackdrop(GuiGraphics guiGraphics) {
            guiGraphics.fill(0, 0, this.drawOrderScreen.width, this.drawOrderScreen.height, ColorHelper.getColor(0, 0, 0, 100));
        }

        public void renderListBackground(GuiGraphics guiGraphics) {
        }

        public void renderListSeparators(GuiGraphics guiGraphics) {
        }
    }

    public static class DrawFeatureEntry
    extends ObjectSelectionList.Entry<DrawFeatureEntry> {
        DrawOrderScreen drawOrderScreen;
        DrawFeatureList drawFeatureList;
        int index;
        int lastRenderX;
        int lastRenderY;
        int lastMouseX;
        int lastMouseY;

        public DrawFeatureEntry(DrawOrderScreen drawOrderScreen, DrawFeatureList drawFeatureList, int index) {
            this.drawOrderScreen = drawOrderScreen;
            this.drawFeatureList = drawFeatureList;
            this.index = index;
        }

        public void renderEntryText(GuiGraphics guiGraphics, int x, int y) {
            String id = this.drawOrderScreen.drawFeatureIdOrder.get(this.index);
            guiGraphics.drawString(DrawOrderScreen.mc.font, id, x + 6, y + 6, -1);
        }

        public Component getNarration() {
            return Component.empty();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            if (this.drawFeatureList.getSelected() != this) {
                guiGraphics.renderOutline(this.getContentX() - 2, this.getContentY(), this.getContentWidth(), this.getContentHeight(), ColorHelper.getColor(68, 68, 68, 255));
            }
            this.lastRenderX = this.getX();
            this.lastRenderY = this.getY();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (!this.drawFeatureList.dragging || this.drawFeatureList.dragged != this.index) {
                this.renderEntryText(guiGraphics, this.getX(), this.getY() + 2);
            }
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (event.button() == 0) {
                this.drawFeatureList.dragging = false;
                this.drawFeatureList.dragged = this.index;
                this.drawFeatureList.draggedOffsetX = (int)((double)this.lastRenderX - event.x());
                this.drawFeatureList.draggedOffsetY = (int)((double)this.lastRenderY - event.y());
                this.drawFeatureList.dragStartX = (int)event.x();
                this.drawFeatureList.dragStartY = (int)event.y();
                if (this.drawFeatureList.getSelected() != this) {
                    return true;
                }
                this.drawFeatureList.setFocused(null);
            } else {
                this.drawFeatureList.setFocused(null);
            }
            return super.mouseClicked(event, doubleClick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            super.mouseMoved(mouseX, mouseY);
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            this.lastMouseX = (int)event.x();
            this.lastMouseY = (int)event.y();
            return super.mouseDragged(event, dragX, dragY);
        }
    }
}

