/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.beacon;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.WaypointVisibilityType;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderer;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.ConfigOption;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

public class WaypointBeaconRenderer {
    public static final WaypointBeaconRenderer INSTANCE = new WaypointBeaconRenderer();
    private final List<Waypoint> waypointList = new ArrayList<Waypoint>();
    private long lastWaypointRenderListUpdate = -1L;
    private int errorCount = 0;

    public void renderHook(PoseStack poseStack, LevelRenderState levelRenderState, SubmitNodeStorage submitNodeStorage) {
        block7: {
            if (!Settings.REGISTRY.waypointBeacons.get()) {
                return;
            }
            HudMod hudMod = HudMod.INSTANCE;
            if (hudMod == null) {
                return;
            }
            Minimap minimap = hudMod.getMinimap();
            if (minimap == null) {
                return;
            }
            WaypointWorldRenderer waypointsIngameRenderer = minimap.getWaypointWorldRenderer();
            if (waypointsIngameRenderer == null) {
                return;
            }
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            try {
                INSTANCE.renderWaypointBeacons(poseStack, levelRenderState, submitNodeStorage);
            }
            catch (Exception e) {
                if (this.errorCount++ >= 2) break block7;
                XaeroPlus.LOGGER.error("Error rendering waypoints", (Throwable)e);
            }
        }
    }

    private void renderWaypointBeacons(PoseStack matrixStack, LevelRenderState levelRenderState, SubmitNodeStorage submitNodeStorage) {
        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return;
        }
        ConfigChannel hudConfigs = HudMod.INSTANCE.getHudConfigs();
        if (hudConfigs == null) {
            return;
        }
        ClientConfigManager clientConfigManager = hudConfigs.getClientConfigManager();
        if (!((Boolean)clientConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_IN_WORLD)).booleanValue()) {
            return;
        }
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastWaypointRenderListUpdate > 50L) {
            this.updateWaypointRenderList(session, clientConfigManager);
            this.lastWaypointRenderListUpdate = System.currentTimeMillis();
        }
        double dimDiv = session.getDimensionHelper().getDimensionDivision(currentWorld);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.getCameraEntity() == null) {
            return;
        }
        if (mc.player.level() != mc.level) {
            return;
        }
        Vec3 cameraPos = mc.getCameraEntity().position();
        double distanceScale = (Boolean)clientConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_MAX_DISTANCE_DIMENSION_SCALE) != false ? mc.level.dimensionType().coordinateScale() : 1.0;
        double waypointsDistance = ((Integer)clientConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_MAX_DISTANCE)).intValue();
        double waypointsDistanceMin = (Double)clientConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_MIN_DISTANCE_IN_WORLD);
        for (int i = 0; i < this.waypointList.size(); ++i) {
            boolean shouldRender;
            WaypointPurpose purpose;
            Waypoint w = this.waypointList.get(i);
            double offX = (double)w.getX(dimDiv) - cameraPos.x + 0.5;
            double offZ = (double)w.getZ(dimDiv) - cameraPos.z + 0.5;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            if (Settings.REGISTRY.limitDeathpointsRenderDistance.get() && (purpose = w.getPurpose()) == WaypointPurpose.DEATH && Settings.REGISTRY.limitDeathpointsRenderDistance.get() && waypointsDistance != 0.0 && distance2D > waypointsDistance) continue;
            boolean bl = shouldRender = w.isDestination() || (w.getPurpose().isDeath() || w.isGlobal() || w.isTemporary() && (Boolean)clientConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.TEMPORARY_WAYPOINTS_GLOBAL) != false || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
            if (!shouldRender) continue;
            this.renderWaypointBeacon(w, dimDiv, matrixStack, levelRenderState, (SubmitNodeCollector)submitNodeStorage);
        }
    }

    public void updateWaypointRenderList(MinimapSession session, ClientConfigManager settings) {
        this.waypointList.clear();
        session.getWaypointSession().getCollector().collect(this.waypointList);
        this.waypointList.removeIf(w -> {
            if (w.isDisabled() || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                return true;
            }
            return (Boolean)settings.getEffective((ConfigOption)MinimapProfiledConfigOptions.DEATHPOINTS) == false && w.getPurpose().isDeath();
        });
        this.waypointList.sort(Waypoint::compareTo);
    }

    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, PoseStack matrixStack, LevelRenderState levelRenderState, SubmitNodeCollector submitNodeCollector) {
        Vec3 waypointVec;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.getCameraEntity() == null) {
            return;
        }
        Vec3 playerVec = mc.getCameraEntity().position();
        double xzDistance = playerVec.distanceTo(waypointVec = new Vec3((double)waypoint.getX(dimDiv), playerVec.y, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)Settings.REGISTRY.waypointBeaconDistanceMin.getAsInt()) {
            return;
        }
        int farScale = Settings.REGISTRY.waypointBeaconScaleMin.getAsInt();
        double maxRenderDistance = Math.min((Integer)mc.options.renderDistance().get() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.subtract(playerVec).normalize();
            waypointVec = playerVec.add(new Vec3(delta.x * maxRenderDistance, delta.y * maxRenderDistance, delta.z * maxRenderDistance));
        }
        EntityRenderDispatcher entityRenderDispatcher = mc.getEntityRenderDispatcher();
        Camera camera = entityRenderDispatcher.camera;
        if (camera == null) {
            return;
        }
        double viewX = camera.position().x();
        double viewZ = camera.position().z();
        double x = waypointVec.x - viewX;
        double z = waypointVec.z - viewZ;
        double y = -100.0;
        int color = waypoint.getWaypointColor().getHex();
        int animationTime = Math.floorMod(mc.level.getGameTime(), 40);
        matrixStack.pushPose();
        matrixStack.translate(x, -100.0, z);
        BeaconRenderer.submitBeaconBeam((PoseStack)matrixStack, (SubmitNodeCollector)submitNodeCollector, (Identifier)BeaconRenderer.BEAM_LOCATION, (float)1.0f, (float)animationTime, (int)0, (int)355, (int)color, (float)0.2f, (float)0.25f);
        matrixStack.popPose();
    }
}

