/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractChunkHighlightDrawFeature;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.AsyncChunkHighlightProvider;
import xaeroplus.shadow.caffeine.cache.AsyncLoadingCache;
import xaeroplus.shadow.caffeine.cache.Caffeine;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class AsyncChunkHighlightDrawFeature
extends AbstractChunkHighlightDrawFeature {
    private final String id;
    private final AsyncLoadingCache<Long, Long2LongMap> chunkRenderCache;
    private final AsyncChunkHighlightProvider chunkHighlightProvider;

    public AsyncChunkHighlightDrawFeature(String id, AbstractHighlightVertexBuffer drawBuffer, AsyncChunkHighlightProvider chunkHighlightProvider) {
        super(drawBuffer);
        this.id = id;
        this.chunkHighlightProvider = chunkHighlightProvider;
        this.chunkRenderCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(500L, TimeUnit.MILLISECONDS).executor(Globals.cacheRefreshExecutorService.get()).removalListener((k, v, cause) -> drawBuffer.markStale()).buildAsync(k -> this.loadFeatureHighlightsInWindow());
    }

    private Long2LongMap loadFeatureHighlightsInWindow() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.chunkHighlightProvider.chunkHighlightSupplier().getHighlights(windowX, windowZ, windowSize, Globals.getCurrentDimensionId());
    }

    @Override
    public String id() {
        return this.id;
    }

    public Long2LongMap chunkHighlights() {
        return this.chunkRenderCache.get(0L).getNow((Long2LongMap)Long2LongMaps.EMPTY_MAP);
    }

    public int color() {
        return this.chunkHighlightProvider.colorSupplier().getAsInt();
    }

    @Override
    public void preRender(DrawContext ctx) {
        super.preRender(ctx);
        this.drawBuffer.preRender(ctx, this.chunkHighlights(), this.color());
    }

    @Override
    public void render(DrawContext ctx) {
        this.preRender(ctx);
        this.drawBuffer.render(ctx, this.chunkHighlights(), this.color());
        this.postRender(ctx);
    }
}

