/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.fluid;

import com.google.common.base.MoreObjects;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.fluid.FluidStack;
import dev.architectury.fluid.forge.ArchitecturyFluidAttributesClient;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

class ArchitecturyFluidAttributesForge
extends FluidType {
    private final ArchitecturyFluidAttributes attributes;
    private final String defaultTranslationKey;

    public ArchitecturyFluidAttributesForge(FluidType.Properties builder, Fluid fluid, ArchitecturyFluidAttributes attributes) {
        super(ArchitecturyFluidAttributesForge.addArchIntoBuilder(builder, attributes));
        this.attributes = attributes;
        this.defaultTranslationKey = Util.makeDescriptionId((String)"fluid", (Identifier)BuiltInRegistries.FLUID.getKey((Object)fluid));
        if (Platform.getEnvironment() == Env.CLIENT) {
            ArchitecturyFluidAttributesClient.registerClient(this, () -> this.attributes);
        }
    }

    private static FluidType.Properties addArchIntoBuilder(FluidType.Properties builder, ArchitecturyFluidAttributes attributes) {
        builder.lightLevel(attributes.getLuminosity()).density(attributes.getDensity()).temperature(attributes.getTemperature()).rarity(attributes.getRarity()).canConvertToSource(attributes.canConvertToSource()).viscosity(attributes.getViscosity());
        return builder;
    }

    public ItemStack getBucket(net.neoforged.neoforge.fluids.FluidStack stack) {
        Item item = this.attributes.getBucketItem();
        return item == null ? super.getBucket(stack) : new ItemStack((ItemLike)item);
    }

    public int getLightLevel(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getLuminosity(this.convertSafe(stack));
    }

    public int getLightLevel(FluidState state, BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getLuminosity(this.convertSafe(state), level, pos);
    }

    public int getDensity(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getDensity(this.convertSafe(stack));
    }

    public int getDensity(FluidState state, BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getDensity(this.convertSafe(state), level, pos);
    }

    public int getTemperature(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getTemperature(this.convertSafe(stack));
    }

    public int getTemperature(FluidState state, BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getTemperature(this.convertSafe(state), level, pos);
    }

    public int getViscosity(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getViscosity(this.convertSafe(stack));
    }

    public int getViscosity(FluidState state, BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getViscosity(this.convertSafe(state), level, pos);
    }

    public Rarity getRarity() {
        return this.attributes.getRarity();
    }

    public Rarity getRarity(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getRarity(this.convertSafe(stack));
    }

    public Component getDescription() {
        return this.attributes.getName();
    }

    public Component getDescription(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.getName(this.convertSafe(stack));
    }

    public String getDescriptionId() {
        return (String)MoreObjects.firstNonNull((Object)this.attributes.getTranslationKey(), (Object)this.defaultTranslationKey);
    }

    public String getDescriptionId(net.neoforged.neoforge.fluids.FluidStack stack) {
        return (String)MoreObjects.firstNonNull((Object)this.attributes.getTranslationKey(this.convertSafe(stack)), (Object)this.defaultTranslationKey);
    }

    @Nullable
    public SoundEvent getSound(SoundAction action) {
        return this.getSound(null, action);
    }

    @Nullable
    public SoundEvent getSound(@Nullable net.neoforged.neoforge.fluids.FluidStack stack, SoundAction action) {
        FluidStack archStack = this.convertSafe(stack);
        if (SoundEvents.BUCKET_FILL.equals((Object)action)) {
            return this.attributes.getFillSound(archStack);
        }
        if (SoundEvents.BUCKET_EMPTY.equals((Object)action)) {
            return this.attributes.getEmptySound(archStack);
        }
        return null;
    }

    @Nullable
    public SoundEvent getSound(@Nullable LivingEntity entity, BlockGetter getter, BlockPos pos, SoundAction action) {
        if (getter instanceof BlockAndTintGetter) {
            BlockAndTintGetter level = (BlockAndTintGetter)getter;
            if (SoundEvents.BUCKET_FILL.equals((Object)action)) {
                return this.attributes.getFillSound(null, level, pos);
            }
            if (SoundEvents.BUCKET_EMPTY.equals((Object)action)) {
                return this.attributes.getEmptySound(null, level, pos);
            }
        }
        return this.getSound(null, action);
    }

    public boolean canConvertToSource(net.neoforged.neoforge.fluids.FluidStack stack) {
        return this.attributes.canConvertToSource();
    }

    public boolean canConvertToSource(FluidState state, LevelReader reader, BlockPos pos) {
        return this.attributes.canConvertToSource();
    }

    @Nullable
    public FluidStack convertSafe(@Nullable net.neoforged.neoforge.fluids.FluidStack stack) {
        return stack == null ? null : FluidStackHooksForge.fromForge(stack);
    }

    @Nullable
    public FluidStack convertSafe(@Nullable FluidState state) {
        return state == null ? null : FluidStack.create(state.getType(), FluidStack.bucketAmount());
    }
}

