/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.registration.IRecipeRegistration;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerVanillaRecipeTypeRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei.JeiRecipeTypeRegistration;
import net.blay09.mods.balm.world.item.crafting.DeferredRecipeType;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;

public class JeiVanillaRecipeTypeRegistration<TRecipeInput extends RecipeInput, TRecipe extends Recipe<TRecipeInput>>
extends JeiRecipeTypeRegistration<TRecipe>
implements RecipeViewerVanillaRecipeTypeRegistration<TRecipeInput, TRecipe> {
    private final List<Holder<RecipeType<TRecipe>>> recipeTypeHolders = new ArrayList<Holder<RecipeType<TRecipe>>>();
    private final List<DeferredRecipeType<TRecipeInput, TRecipe>> deferredRecipeTypes = new ArrayList<DeferredRecipeType<TRecipeInput, TRecipe>>();

    public JeiVanillaRecipeTypeRegistration(Identifier identifier, Class<TRecipe> recipeClass) {
        super(identifier, recipeClass);
    }

    @Override
    public RecipeViewerVanillaRecipeTypeRegistration<TRecipeInput, TRecipe> withSyncedRecipes(Holder<RecipeType<TRecipe>> recipeType) {
        this.recipeTypeHolders.add(recipeType);
        return this;
    }

    @Override
    public RecipeViewerVanillaRecipeTypeRegistration<TRecipeInput, TRecipe> withSyncedRecipes(DeferredRecipeType<TRecipeInput, TRecipe> recipeType) {
        this.deferredRecipeTypes.add(recipeType);
        return this;
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        Balm.safeClientAccess().getRecipeMap().ifPresent(recipeMap -> {
            List<Recipe> recipes;
            for (Holder<RecipeType<TRecipe>> holder : this.recipeTypeHolders) {
                recipes = recipeMap.byType((RecipeType)holder.value()).stream().map(RecipeHolder::value).toList();
                registration.addRecipes(this.jeiRecipeType, recipes);
            }
            for (DeferredRecipeType deferredRecipeType : this.deferredRecipeTypes) {
                recipes = recipeMap.byType(deferredRecipeType.type()).stream().map(RecipeHolder::value).toList();
                registration.addRecipes(this.jeiRecipeType, recipes);
            }
        });
    }

    public boolean containsRecipeType(RecipeType<?> recipeType) {
        return this.recipeTypeHolders.stream().anyMatch(it -> it.value() == recipeType) || this.deferredRecipeTypes.stream().anyMatch(it -> it.type() == recipeType);
    }
}

