/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.energy;

import net.blay09.mods.balm.platform.energy.EnergyStorage;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DefaultEnergyStorage
implements EnergyStorage {
    private final int capacity;
    private final int maxFill;
    private final int maxDrain;
    private int energy;

    public DefaultEnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public DefaultEnergyStorage(int capacity, int maxTransfer) {
        this(maxTransfer, capacity, maxTransfer, 0);
    }

    public DefaultEnergyStorage(int capacity, int maxFill, int maxDrain) {
        this(maxDrain, capacity, maxFill, 0);
    }

    public DefaultEnergyStorage(int maxDrain, int capacity, int maxFill, int amount) {
        this.capacity = capacity;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        this.energy = Math.max(0, Math.min(capacity, amount));
    }

    @Override
    public int fill(int maxFill, boolean simulate) {
        if (!this.canFill()) {
            return 0;
        }
        int filled = Math.min(this.capacity - this.energy, Math.min(this.maxFill, maxFill));
        if (!simulate) {
            this.energy += filled;
            this.setChanged();
        }
        return filled;
    }

    @Override
    public int drain(int maxDrain, boolean simulate) {
        if (!this.canDrain()) {
            return 0;
        }
        int drained = Math.min(this.energy, Math.min(this.maxDrain, maxDrain));
        if (!simulate) {
            this.energy -= drained;
            this.setChanged();
        }
        return drained;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(int energy) {
        this.energy = energy;
        this.setChanged();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean canDrain() {
        return this.maxDrain > 0;
    }

    @Override
    public boolean canFill() {
        return this.maxFill > 0;
    }

    public void serialize(ValueOutput output) {
        output.putInt("Energy", this.energy);
    }

    public void deserialize(ValueInput input) {
        this.energy = input.getIntOr("Energy", 0);
    }

    public void setChanged() {
    }
}

