/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.permissions.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.blay09.mods.balm.platform.permissions.BalmPermissions;
import net.blay09.mods.balm.platform.permissions.PermissionContext;
import net.blay09.mods.balm.platform.permissions.internal.CommandPermissionContext;
import net.blay09.mods.balm.platform.permissions.internal.PlayerPermissionContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;

public class CommonBalmPermissions
implements BalmPermissions {
    private final Map<Identifier, Function<PermissionContext, Boolean>> resolvers = new ConcurrentHashMap<Identifier, Function<PermissionContext, Boolean>>();

    @Override
    public void registerPermission(Identifier permission, Function<PermissionContext, Boolean> defaultResolver) {
        this.resolvers.put(permission, defaultResolver);
    }

    @Override
    public boolean hasPermission(ServerPlayer player, Identifier permission) {
        Function<PermissionContext, Boolean> node = this.resolvers.get(permission);
        if (node == null) {
            return false;
        }
        return node.apply(new PlayerPermissionContext(player));
    }

    @Override
    public boolean hasPermission(CommandSourceStack source, Identifier permission) {
        Function<PermissionContext, Boolean> node = this.resolvers.get(permission);
        if (node == null) {
            return false;
        }
        return node.apply(new CommandPermissionContext(source));
    }
}

