/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class BrewingStandProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final MapCodec<BrewingStandProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("slotFillChance", (Object)Float.valueOf(0.5f)).forGetter(p -> Float.valueOf(p.slotFillChance)), (App)Codec.intRange((int)0, (int)64).optionalFieldOf("maxBlazePowder", (Object)16).forGetter(p -> p.maxBlazePowder)).apply((Applicative)instance, BrewingStandProcessor::new));
    private final float slotFillChance;
    private final int maxBlazePowder;

    public BrewingStandProcessor(float slotFillChance, int maxBlazePowder) {
        this.slotFillChance = slotFillChance;
        this.maxBlazePowder = maxBlazePowder;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        if (block.state() != null && block.state().is(Blocks.BREWING_STAND)) {
            BlockState state = block.state();
            NonNullList potions = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
            if (block.nbt() != null) {
                Identifier name = level.registryAccess().lookupOrThrow(Registries.STRUCTURE_PROCESSOR).getKey(this.getType());
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(() -> ((Identifier)name).toString(), Formations.LOGGER);){
                    ContainerHelper.loadAllItems((ValueInput)TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)block.nbt()), (NonNullList)potions);
                }
            }
            RandomSource random = placeSettings.getRandom(pos);
            for (int i = 0; i < 3; ++i) {
                if (!((ItemStack)potions.get(i)).isEmpty() || !(random.nextFloat() < this.slotFillChance)) continue;
                Holder potion = (Holder)BuiltInRegistries.POTION.getRandom(random).get();
                ItemStack bottle = PotionContents.createItemStack((Item)(random.nextFloat() < 0.4f ? Items.POTION : (random.nextFloat() < 0.66f ? Items.SPLASH_POTION : Items.LINGERING_POTION)), (Holder)potion);
                potions.set(i, (Object)bottle);
                state = (BlockState)state.setValue((Property)BrewingStandBlock.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(true));
            }
            CompoundTag nbt = block.nbt() == null ? new CompoundTag() : block.nbt().copy();
            Identifier name = level.registryAccess().lookupOrThrow(Registries.STRUCTURE_PROCESSOR).getKey(this.getType());
            try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(() -> ((Identifier)name).toString(), Formations.LOGGER);){
                TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)level.registryAccess());
                ContainerHelper.saveAllItems((ValueOutput)output, (NonNullList)potions);
                nbt.merge(output.buildResult());
            }
            return new BlockInstance(state, nbt);
        }
        return block;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.BREWING_STAND_PROCESSOR.get();
    }
}

