/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import com.supermartijn642.formations.tools.template.TemplateRenderer;
import com.supermartijn642.formations.tools.template.packets.CreateTemplatePacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import com.supermartijn642.formations.tools.template.screen.TemplateEditButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemplateEditingScreen
extends BaseWidget {
    private static final Identifier SCREEN_BACKGROUND = Formations.location("textures/gui/template_creation_screen.png");
    private final Template template;
    private TemplateEditButton saveButton;

    public TemplateEditingScreen(Template template) {
        super(0, 0, 144, 166);
        this.template = template;
    }

    public Component getNarrationMessage() {
        return this.template == null ? TextComponents.translation((String)"formations.template.edit.new_template").get() : TextComponents.translation((String)"formations.template.edit.edit_template").get();
    }

    public void addWidgets() {
        if (this.template == null) {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, "", 50, t -> {
                this.saveButton.active = Template.isValidName(t) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null;
            });
            nameField.setSuggestion(I18n.get((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.cancel").get(), TemplateEditButton.LEFT_BUTTON, () -> {
                TemplateRenderer.selectionDimension = null;
                ClientUtils.getMinecraft().setScreen(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.save").get(), TemplateEditButton.GREEN_RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(new AABB(TemplateRenderer.selectionPos1).minmax(new AABB(TemplateRenderer.selectionPos2)), name)));
                    TemplateRenderer.selectionDimension = null;
                    ClientUtils.getMinecraft().setScreen(null);
                }
            });
            this.saveButton.active = false;
            this.addWidget((Widget)this.saveButton);
        } else {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, this.template.getName(), 50, t -> {
                this.saveButton.active = Template.isValidName(t) && (t.trim().equals(this.template.getName()) || TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null);
            });
            nameField.setSuggestion(I18n.get((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.delete").get(), TemplateEditButton.RED_LEFT_BUTTON, () -> {
                FormationsDev.CHANNEL.sendToServer((BasePacket)new DeleteTemplatePacket(this.template));
                ClientUtils.getMinecraft().setScreen(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.confirm").get(), TemplateEditButton.RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (name.equals(this.template.getName())) {
                    ClientUtils.getMinecraft().setScreen(null);
                } else if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(this.template.getArea(), name)));
                    ClientUtils.getMinecraft().setScreen(null);
                }
            });
            this.saveButton.active = true;
            this.addWidget((Widget)this.saveButton);
        }
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        super.renderBackground(context, graphics, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        super.renderForeground(context, graphics, mouseX, mouseY);
        AABB area = this.template == null ? new AABB(TemplateRenderer.selectionPos1).minmax(new AABB(TemplateRenderer.selectionPos2)) : this.template.getArea();
        Vec3 center = area.getCenter();
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.new_template").get(), 72.0f, 3.0f, p -> p.shadow().activeColor().centerHorizontally());
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.name").get(), 32.0f, 22.0f, p -> p.centerHorizontally());
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.location").get(), 32.0f, 51.0f, p -> p.centerHorizontally());
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.location.x").get(), 10.0f, 63.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.location.y").get(), 10.0f, 74.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.location.z").get(), 10.0f, 85.0f);
        Font font = ClientUtils.getFontRenderer();
        MutableComponent posX = TextComponents.number((double)center.x, (int)1).get();
        MutableComponent posY = TextComponents.number((double)center.y, (int)1).get();
        MutableComponent posZ = TextComponents.number((double)center.z, (int)1).get();
        graphics.submitText((FormattedText)posX, (float)(132 - font.width((FormattedText)posX)), 63.0f);
        graphics.submitText((FormattedText)posY, (float)(132 - font.width((FormattedText)posY)), 74.0f);
        graphics.submitText((FormattedText)posZ, (float)(132 - font.width((FormattedText)posZ)), 85.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.size").get(), 32.0f, 101.0f, p -> p.centerHorizontally());
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.size.x").get(), 10.0f, 113.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.size.y").get(), 10.0f, 124.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"formations.template.edit.size.z").get(), 10.0f, 135.0f);
        MutableComponent sizeX = TextComponents.number((int)((int)area.getXsize())).get();
        MutableComponent sizeY = TextComponents.number((int)((int)area.getYsize())).get();
        MutableComponent sizeZ = TextComponents.number((int)((int)area.getZsize())).get();
        graphics.submitText((FormattedText)sizeX, (float)(132 - font.width((FormattedText)sizeX)), 113.0f);
        graphics.submitText((FormattedText)sizeY, (float)(132 - font.width((FormattedText)sizeY)), 124.0f);
        graphics.submitText((FormattedText)sizeZ, (float)(132 - font.width((FormattedText)sizeZ)), 135.0f);
    }
}

