/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.config;

import java.io.IOException;
import java.util.Locale;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatterImpls;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.features.FeatureFlags;
import net.irisshaders.iris.gui.option.IrisVideoSettings;
import net.irisshaders.iris.gui.screen.ShaderPackScreen;
import net.irisshaders.iris.pathways.colorspace.ColorSpace;
import net.minecraft.client.Minecraft;
import net.minecraft.client.TextureFilteringMethod;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class IrisConfig
implements ConfigEntryPoint {
    public static final Identifier MONO = Identifier.fromNamespaceAndPath((String)"iris", (String)"textures/gui/config-icon-mono.png");
    public static final Identifier COLOR = Identifier.fromNamespaceAndPath((String)"iris", (String)"textures/gui/config-icon.png");

    public void registerConfigLate(ConfigBuilder builder) {
        builder.registerOwnModOptions().setName("Iris").setIcon(MONO).setColorTheme(builder.createColorTheme().setBaseThemeRGB(-698654)).setVersion(Iris.getVersionSimple()).addPage((PageBuilder)builder.createExternalPage().setName((Component)Component.translatable((String)"options.iris.shaderPackSelection.title")).setScreenConsumer(i -> Minecraft.getInstance().setScreen((Screen)new ShaderPackScreen((Screen)i)))).addPage((PageBuilder)builder.createOptionPage().setName((Component)Component.literal((String)"Settings")).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createExternalButtonOption(Identifier.fromNamespaceAndPath((String)"iris", (String)"settings")).setTooltip((Component)Component.empty()).setName((Component)Component.translatable((String)"options.iris.shaderPackList")).setScreenConsumer(i -> Minecraft.getInstance().setScreen((Screen)new ShaderPackScreen((Screen)i))))).addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createEnumOption(Identifier.fromNamespaceAndPath((String)"iris", (String)"colorSpace"), ColorSpace.class).setBinding(i -> {
            IrisVideoSettings.colorSpace = i;
        }, () -> IrisVideoSettings.colorSpace).setName((Component)Component.translatable((String)"options.iris.colorSpace")).setDefaultValue((Enum)ColorSpace.SRGB).setTooltip((Component)Component.translatable((String)"options.iris.colorSpace.sodium_tooltip")).setStorageHandler(() -> {
            try {
                Iris.getIrisConfig().save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).setElementNameProvider(ColorSpace::getName)).addOption((OptionBuilder)builder.createIntegerOption(Identifier.fromNamespaceAndPath((String)"iris", (String)"shadowDistance")).setDefaultValue(Integer.valueOf(32)).setBinding(value -> {
            IrisVideoSettings.shadowDistance = value;
        }, () -> IrisVideoSettings.getOverriddenShadowDistance(IrisVideoSettings.shadowDistance)).setName((Component)Component.translatable((String)"options.iris.shadowDistance")).setTooltip(i -> {
            if (!IrisVideoSettings.isShadowDistanceSliderEnabled()) {
                return Component.translatable((String)"options.iris.shadowDistance.disabled");
            }
            return Component.translatable((String)"options.iris.shadowDistance.sodium_tooltip");
        }).setValueFormatter(ControlValueFormatterImpls.quantityOrDisabled(i -> Component.translatable((String)"options.chunks", (Object[])new Object[]{i}), (Component)Component.literal((String)"None"))).setEnabledProvider(i -> IrisVideoSettings.isShadowDistanceSliderEnabled(), new Identifier[]{ConfigState.UPDATE_ON_REBUILD}).setStorageHandler(() -> {
            try {
                Iris.getIrisConfig().save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).setRange(new Range(0, 32, 1)).setImpact(OptionImpact.HIGH)))).registerOptionOverlay(Identifier.parse((String)"sodium:quality.filtering_mode"), (OptionBuilder)builder.createEnumOption(Identifier.parse((String)"sodium:quality.filtering_mode"), TextureFilteringMethod.class).setTooltip(i -> {
            if (Iris.getCurrentPack().isPresent() && !Iris.getCurrentPack().get().hasFeature(FeatureFlags.TEXTURE_FILTERING)) {
                return Component.literal((String)"Your currently active shader pack does not support this.");
            }
            return Component.translatable((String)("options.textureFiltering." + i.name().toLowerCase(Locale.ROOT) + ".tooltip"));
        }).setEnabledProvider(i -> Iris.getCurrentPack().isEmpty() || Iris.getCurrentPack().get().hasFeature(FeatureFlags.TEXTURE_FILTERING), new Identifier[]{ConfigState.UPDATE_ON_REBUILD})).registerOptionOverlay(Identifier.parse((String)"sodium:quality.graphics"), (OptionBuilder)builder.createBooleanOption(Identifier.parse((String)"sodium:quality.graphics")).setTooltip(i -> {
            if (Iris.getCurrentPack().isPresent()) {
                return Component.literal((String)"This option is not relevant when a shader pack is active.");
            }
            return Component.translatable((String)"options.improvedTransparency.tooltip");
        }).setEnabledProvider(i -> Iris.getCurrentPack().isEmpty(), new Identifier[]{ConfigState.UPDATE_ON_REBUILD})).registerOptionOverlay(Identifier.parse((String)"sodium:quality.anisotropy_bit"), (OptionBuilder)builder.createIntegerOption(Identifier.parse((String)"sodium:quality.anisotropy_bit")).setEnabledProvider(i -> Iris.getCurrentPack().isEmpty() || Iris.getCurrentPack().get().hasFeature(FeatureFlags.TEXTURE_FILTERING), new Identifier[]{ConfigState.UPDATE_ON_REBUILD}));
    }
}

