/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.renderer.SkyRenderer;
import net.minecraft.world.level.MoonPhase;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkyRenderer.class})
public class MixinSkyRenderer {
    @Inject(method={"renderSkyDisc"}, at={@At(value="HEAD")})
    private void iris$renderSky$beginNormalSky(int i, CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.SKY);
    }

    @Inject(method={"renderSun"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$beforeDrawSun(float f, PoseStack poseStack, CallbackInfo ci) {
        if (!Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::shouldRenderSun).orElse(true).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderMoon"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$beforeDrawMoon(MoonPhase moonPhase, float f, PoseStack poseStack, CallbackInfo ci) {
        if (!Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::shouldRenderMoon).orElse(true).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSun"}, at={@At(value="HEAD")})
    private void iris$setSunRenderStage(float f, PoseStack poseStack, CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.SUN);
    }

    @Inject(method={"renderMoon"}, at={@At(value="HEAD")})
    private void iris$setMoonRenderStage(MoonPhase moonPhase, float f, PoseStack poseStack, CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.MOON);
    }

    @Inject(method={"renderSunriseAndSunset"}, at={@At(value="HEAD")})
    private void iris$setSunsetRenderStage(PoseStack poseStack, float f, int i, CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.SUNSET);
    }

    @Inject(method={"renderStars"}, at={@At(value="HEAD")})
    private void iris$setStarRenderStage(float f, PoseStack poseStack, CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.STARS);
    }

    @Inject(method={"renderDarkDisc"}, at={@At(value="HEAD")})
    private void iris$setVoidRenderStage(CallbackInfo ci) {
        this.setPhase(WorldRenderingPhase.VOID);
    }

    @Inject(method={"renderSunMoonAndStars"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void iris$renderSky$tiltSun(PoseStack poseStack, float f, float g, float h, MoonPhase moonPhase, float i, float j, CallbackInfo ci) {
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(this.getSunPathRotation()));
    }

    private float getSunPathRotation() {
        if (Iris.getPipelineManager().getPipelineNullable() == null) {
            return 0.0f;
        }
        return Iris.getPipelineManager().getPipelineNullable().getSunPathRotation();
    }

    public void setPhase(WorldRenderingPhase phase) {
        if (Iris.getPipelineManager().getPipelineNullable() == null) {
            return;
        }
        Iris.getPipelineManager().getPipelineNullable().setPhase(phase);
    }
}

