/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderOverrides;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.client.renderer.RenderPipelines;
import org.jetbrains.annotations.Nullable;

public class IrisPipelines {
    private static final Map<RenderPipeline, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMap = new Object2ObjectArrayMap();
    private static final Map<RenderPipeline, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMapShadow = new Object2ObjectArrayMap();
    private static final Function<IrisRenderingPipeline, ShaderKey> FAKE_FUNCTION = p -> null;

    private static ShaderKey getText(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.TEXT_BE;
        }
        return ShaderKey.TEXT;
    }

    private static ShaderKey getTextIntensity(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.TEXT_INTENSITY_BE;
        }
        return ShaderKey.TEXT_INTENSITY;
    }

    private static void assignToMain(RenderPipeline pipeline, Function<IrisRenderingPipeline, ShaderKey> o) {
        ShaderKey newKey;
        Function<IrisRenderingPipeline, ShaderKey> current;
        ShaderKey currentKey;
        if (coreShaderMap.containsKey(pipeline) && (currentKey = (ShaderKey)((Object)(current = coreShaderMap.get(pipeline)).apply(null))) != (newKey = (ShaderKey)((Object)o.apply(null)))) {
            Iris.logger.warn("Pair already assigned: " + String.valueOf(pipeline) + " to " + String.valueOf((Object)currentKey) + " -> " + String.valueOf((Object)newKey));
        }
        coreShaderMap.put(pipeline, o);
    }

    private static void assignToShadow(RenderPipeline pipeline, Function<IrisRenderingPipeline, ShaderKey> o) {
        if (coreShaderMapShadow.containsKey(pipeline)) {
            Iris.logger.warn("Pair already assigned: " + String.valueOf(pipeline));
        }
        coreShaderMapShadow.put(pipeline, o);
    }

    private static ShaderKey getCutout(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY_DIFFUSE;
        }
        return ShaderKey.ENTITIES_CUTOUT_DIFFUSE;
    }

    private static ShaderKey getSolid(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_SOLID;
    }

    private static ShaderKey getTranslucent(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_TRANSLUCENT;
    }

    @Nullable
    public static ShaderKey getPipeline(IrisRenderingPipeline pipeline, RenderPipeline shader) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            return (ShaderKey)((Object)coreShaderMapShadow.getOrDefault(shader, FAKE_FUNCTION).apply((Object)pipeline));
        }
        return (ShaderKey)((Object)coreShaderMap.getOrDefault(shader, FAKE_FUNCTION).apply((Object)pipeline));
    }

    public static void assignPipeline(RenderPipeline pipeline, ShaderKey programId) {
        if (coreShaderMap.containsKey(pipeline)) {
            throw new IllegalStateException("Shader already assigned: " + String.valueOf(pipeline.getLocation()) + ": " + String.valueOf((Object)programId));
        }
        coreShaderMap.put(pipeline, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> programId));
    }

    public static void copyPipeline(RenderPipeline pipelineToCopy, RenderPipeline returnValue) {
        if (coreShaderMap.containsKey(pipelineToCopy)) {
            coreShaderMap.put(returnValue, coreShaderMap.get(pipelineToCopy));
        }
        if (coreShaderMapShadow.containsKey(pipelineToCopy)) {
            coreShaderMapShadow.put(returnValue, coreShaderMapShadow.get(pipelineToCopy));
        }
    }

    static {
        IrisPipelines.assignToMain(RenderPipelines.SOLID_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_SOLID));
        IrisPipelines.assignToMain(RenderPipelines.CUTOUT_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_CUTOUT));
        IrisPipelines.assignToMain(RenderPipelines.SOLID_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_SOLID));
        IrisPipelines.assignToMain(RenderPipelines.CUTOUT_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_CUTOUT));
        IrisPipelines.assignToMain(RenderPipelines.TRANSLUCENT_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        IrisPipelines.assignToMain(RenderPipelines.TRANSLUCENT_MOVING_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.MOVING_BLOCK));
        IrisPipelines.assignToMain(RenderPipelines.TRIPWIRE_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        IrisPipelines.assignToMain(RenderPipelines.WORLD_BORDER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXTURED));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_CUTOUT_NO_CULL_Z_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_SMOOTH_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_SHADOW, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_NO_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_DECAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.LINES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        IrisPipelines.assignToMain(RenderPipelines.SECONDARY_BLOCK_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        IrisPipelines.assignToMain(RenderPipelines.STARS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC));
        IrisPipelines.assignToMain(RenderPipelines.SUNRISE_SUNSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC_COLOR));
        IrisPipelines.assignToMain(RenderPipelines.SKY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC));
        IrisPipelines.assignToMain(RenderPipelines.CELESTIAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_TEXTURED));
        IrisPipelines.assignToMain(RenderPipelines.OPAQUE_PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES));
        IrisPipelines.assignToMain(RenderPipelines.TRANSLUCENT_PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES_TRANS));
        IrisPipelines.assignToMain(RenderPipelines.WATER_MASK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BASIC));
        IrisPipelines.assignToMain(RenderPipelines.GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        IrisPipelines.assignToMain(RenderPipelines.ARMOR_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.EYES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_TRANSLUCENT_EMISSIVE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES_TRANS));
        IrisPipelines.assignToMain(RenderPipelines.ARMOR_DECAL_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(RenderPipelines.ARMOR_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.BREEZE_WIND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getSolid(p)));
        IrisPipelines.assignToMain(RenderPipelines.ENTITY_SOLID_Z_OFFSET_FORWARD, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getSolid(p)));
        IrisPipelines.assignToMain(RenderPipelines.END_GATEWAY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BLOCK_ENTITY));
        IrisPipelines.assignToMain(RenderPipelines.ENERGY_SWIRL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT));
        IrisPipelines.assignToMain(RenderPipelines.LIGHTNING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(RenderPipelines.DRAGON_RAYS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(RenderPipelines.DRAGON_RAYS_DEPTH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(RenderPipelines.BEACON_BEAM_OPAQUE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        IrisPipelines.assignToMain(RenderPipelines.BEACON_BEAM_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        IrisPipelines.assignToMain(RenderPipelines.END_PORTAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BLOCK_ENTITY));
        IrisPipelines.assignToMain(RenderPipelines.END_SKY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_TEXTURED));
        IrisPipelines.assignToMain(RenderPipelines.WEATHER_DEPTH_WRITE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        IrisPipelines.assignToMain(RenderPipelines.WEATHER_NO_DEPTH_WRITE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        IrisPipelines.assignToMain(RenderPipelines.TEXT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_POLYGON_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_INTENSITY_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTextIntensity(p)));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_BACKGROUND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_BACKGROUND_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        IrisPipelines.assignToMain(RenderPipelines.TEXT_INTENSITY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTextIntensity(p)));
        IrisPipelines.assignToMain(RenderPipelines.DRAGON_EXPLOSION_ALPHA, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_ALPHA));
        IrisPipelines.assignToMain(RenderPipelines.CRUMBLING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CRUMBLING));
        IrisPipelines.assignToMain(RenderPipelines.LEASH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LEASH));
        IrisPipelines.assignToMain(RenderPipelines.CLOUDS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS));
        IrisPipelines.assignToMain(RenderPipelines.FLAT_CLOUDS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS));
        IrisPipelines.assignToShadow(RenderPipelines.SOLID_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.SOLID_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.CUTOUT_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.TRANSLUCENT_TERRAIN, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(RenderPipelines.CUTOUT_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.TRANSLUCENT_MOVING_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(RenderPipelines.TRIPWIRE_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ARMOR_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ITEM_ENTITY_TRANSLUCENT_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ARMOR_DECAL_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.CRUMBLING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_SOLID_Z_OFFSET_FORWARD, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_CUTOUT_NO_CULL_Z_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_SMOOTH_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_TRANSLUCENT_EMISSIVE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.BREEZE_WIND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.EYES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.DRAGON_EXPLOSION_ALPHA, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_NO_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENERGY_SWIRL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.ENTITY_DECAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.WEATHER_DEPTH_WRITE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(RenderPipelines.WEATHER_NO_DEPTH_WRITE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(RenderPipelines.OPAQUE_PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(RenderPipelines.TRANSLUCENT_PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(RenderPipelines.LINES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        IrisPipelines.assignToShadow(RenderPipelines.LEASH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LEASH));
        IrisPipelines.assignToShadow(RenderPipelines.SECONDARY_BLOCK_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_POLYGON_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_INTENSITY_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_BACKGROUND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_BACKGROUND_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        IrisPipelines.assignToShadow(RenderPipelines.TEXT_INTENSITY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        IrisPipelines.assignToShadow(RenderPipelines.WATER_MASK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        IrisPipelines.assignToShadow(RenderPipelines.BEACON_BEAM_OPAQUE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        IrisPipelines.assignToShadow(RenderPipelines.BEACON_BEAM_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        IrisPipelines.assignToShadow(RenderPipelines.END_PORTAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BLOCK));
        IrisPipelines.assignToShadow(RenderPipelines.END_GATEWAY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BLOCK));
        IrisPipelines.assignToShadow(RenderPipelines.ARMOR_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(RenderPipelines.LIGHTNING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LIGHTNING));
    }
}

