/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.gui.option.IrisVideoSettings;
import net.irisshaders.iris.helpers.JomlConversions;
import net.irisshaders.iris.mixin.GameRendererAccessor;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.uniforms.CameraUniforms;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.EndFlashStorage;
import net.irisshaders.iris.uniforms.FrameUpdateNotifier;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.TextureFilteringMethod;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class IrisExclusiveUniforms {
    private static final Vector3d ZERO = new Vector3d(0.0);

    public static void addIrisExclusiveUniforms(UniformHolder uniforms, FrameUpdateNotifier updateNotifier) {
        WorldInfoUniforms.addWorldInfoUniforms(uniforms);
        EndFlashStorage endFlashStorage = new EndFlashStorage();
        updateNotifier.addListener(endFlashStorage::tick);
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "currentColorSpace", () -> IrisVideoSettings.colorSpace.ordinal());
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "chunkFadeTimeInv", () -> (float)(1.0 / ((Double)Minecraft.getInstance().options.chunkSectionFadeInTime().get() * 1000.0)));
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "textureFilteringMode", () -> switch ((TextureFilteringMethod)Minecraft.getInstance().options.textureFiltering().get()) {
            default -> throw new MatchException(null, null);
            case TextureFilteringMethod.NONE -> 0;
            case TextureFilteringMethod.RGSS -> 1;
            case TextureFilteringMethod.ANISOTROPIC -> 2;
        });
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "feetInWater", IrisExclusiveUniforms::getIsInShallowWater);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "inSwimmingAnimation", IrisExclusiveUniforms::getIsSwimming);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isRiding", IrisExclusiveUniforms::getIsPassenger);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "vehicleInWater", IrisExclusiveUniforms::getVehicleInShallowWater);
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "vehicleId", IrisExclusiveUniforms::getVehicleId);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "vehicleLookVector", IrisExclusiveUniforms::getVehicleLookVector);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "relativeVehiclePosition", IrisExclusiveUniforms::getRelativeVehiclePosition);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "heavyFog", IrisExclusiveUniforms::isHeavyFog);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "endFlashIntensity", endFlashStorage::getCurrentEndFlash);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "previousEndFlashIntensity", endFlashStorage::getLastEndFlash);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerArmor", IrisExclusiveUniforms::getCurrentArmor);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerArmor", () -> 50);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "currentSelectedBlockId", IrisExclusiveUniforms::getCurrentSelectedBlockId);
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "seaLevel", () -> Minecraft.getInstance().level == null ? 0 : Minecraft.getInstance().level.getSeaLevel());
        uniforms.uniform3f(UniformUpdateFrequency.PER_FRAME, "currentSelectedBlockPos", IrisExclusiveUniforms::getCurrentSelectedBlockPos);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "cloudTime", CapturedRenderingState.INSTANCE::getCloudTime);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "relativeEyePosition", () -> CameraUniforms.getUnshiftedCameraPosition().sub((Vector3dc)IrisExclusiveUniforms.getEyePosition()));
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "playerLookVector", () -> {
            Entity patt0$temp = Minecraft.getInstance().getCameraEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                return JomlConversions.fromVec3(livingEntity.getViewVector(CapturedRenderingState.INSTANCE.getTickDelta()));
            }
            return ZERO;
        });
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "playerBodyVector", () -> JomlConversions.fromVec3(Minecraft.getInstance().getCameraEntity().getForward()));
        Vector4f zero = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        uniforms.uniform4f(UniformUpdateFrequency.PER_TICK, "lightningBoltPosition", () -> {
            if (Minecraft.getInstance().level != null) {
                return StreamSupport.stream(Minecraft.getInstance().level.entitiesForRendering().spliterator(), false).filter(bolt -> bolt instanceof LightningBolt).findAny().map(bolt -> {
                    Vector3d unshiftedCameraPosition = CameraUniforms.getUnshiftedCameraPosition();
                    Vec3 vec3 = bolt.getPosition(Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true));
                    return new Vector4f((float)(vec3.x - unshiftedCameraPosition.x), (float)(vec3.y - unshiftedCameraPosition.y), (float)(vec3.z - unshiftedCameraPosition.z), 1.0f);
                }).orElse(zero);
            }
            return zero;
        });
    }

    private static int getVehicleId() {
        if (Minecraft.getInstance().player == null) {
            return 0;
        }
        if (Minecraft.getInstance().player.getVehicle() == null) {
            return 0;
        }
        Object2IntFunction<NamespacedId> entityId = WorldRenderingSettings.INSTANCE.getEntityIds();
        if (entityId == null) {
            return 0;
        }
        Identifier id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)Minecraft.getInstance().player.getVehicle().getType());
        if (id == null) {
            return 0;
        }
        return entityId.applyAsInt((Object)new NamespacedId(id.getNamespace(), id.getPath()));
    }

    private static Vector3d getVehicleLookVector() {
        if (Minecraft.getInstance().player == null) {
            return ZERO;
        }
        if (Minecraft.getInstance().player.getVehicle() == null) {
            return ZERO;
        }
        return JomlConversions.fromVec3(Minecraft.getInstance().player.getVehicle().getForward());
    }

    private static Vector3d getRelativeVehiclePosition() {
        if (Minecraft.getInstance().player == null) {
            return ZERO;
        }
        if (Minecraft.getInstance().player.getVehicle() == null) {
            return ZERO;
        }
        Vec3 vehiclePos = Minecraft.getInstance().player.getVehicle().getPosition(CapturedRenderingState.INSTANCE.getTickDelta());
        Vector3d pos = new Vector3d(vehiclePos.x, vehiclePos.y, vehiclePos.z);
        return CameraUniforms.getUnshiftedCameraPosition().sub((Vector3dc)pos);
    }

    private static boolean getVehicleInShallowWater() {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (Minecraft.getInstance().player.getVehicle() == null) {
            return false;
        }
        return Minecraft.getInstance().player.getVehicle().isInShallowWater();
    }

    private static boolean getIsInShallowWater() {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        return Minecraft.getInstance().player.isInShallowWater();
    }

    private static boolean getIsSwimming() {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        return Minecraft.getInstance().player.isSwimming();
    }

    private static boolean getIsPassenger() {
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        return Minecraft.getInstance().player.isPassenger();
    }

    private static boolean isHeavyFog() {
        if (Minecraft.getInstance().level != null) {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            return Minecraft.getInstance().gui.getBossOverlay().shouldCreateWorldFog();
        }
        return false;
    }

    private static int getCurrentSelectedBlockId() {
        BlockPos blockPos4;
        BlockState blockState;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (Minecraft.getInstance().level != null && ((GameRendererAccessor)Minecraft.getInstance().gameRenderer).shouldRenderBlockOutlineA() && hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && !(blockState = Minecraft.getInstance().level.getBlockState(blockPos4 = ((BlockHitResult)hitResult).getBlockPos())).isAir() && Minecraft.getInstance().level.getWorldBorder().isWithinBounds(blockPos4)) {
            return WorldRenderingSettings.INSTANCE.getBlockStateIds().getInt((Object)blockState);
        }
        return 0;
    }

    private static Vector3f getCurrentSelectedBlockPos() {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (Minecraft.getInstance().level != null && ((GameRendererAccessor)Minecraft.getInstance().gameRenderer).shouldRenderBlockOutlineA() && hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos4 = ((BlockHitResult)hitResult).getBlockPos();
            return blockPos4.getCenter().subtract(Minecraft.getInstance().gameRenderer.getMainCamera().position()).toVector3f();
        }
        return new Vector3f(-256.0f);
    }

    private static float getThunderStrength() {
        return Math.clamp((float)0.0f, (float)1.0f, (float)Minecraft.getInstance().level.getThunderLevel(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static float getCurrentHealth() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return Minecraft.getInstance().player.getHealth() / Minecraft.getInstance().player.getMaxHealth();
    }

    private static float getCurrentHunger() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return (float)Minecraft.getInstance().player.getFoodData().getFoodLevel() / 20.0f;
    }

    private static float getCurrentAir() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return (float)Minecraft.getInstance().player.getAirSupply() / (float)Minecraft.getInstance().player.getMaxAirSupply();
    }

    private static float getCurrentArmor() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return (float)Minecraft.getInstance().player.getArmorValue() / 50.0f;
    }

    private static float getMaxAir() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return Minecraft.getInstance().player.getMaxAirSupply();
    }

    private static float getMaxHealth() {
        if (Minecraft.getInstance().player == null || !Minecraft.getInstance().gameMode.getPlayerMode().isSurvival()) {
            return -1.0f;
        }
        return Minecraft.getInstance().player.getMaxHealth();
    }

    private static boolean isFirstPersonCamera() {
        return switch (Minecraft.getInstance().options.getCameraType()) {
            case CameraType.THIRD_PERSON_BACK, CameraType.THIRD_PERSON_FRONT -> false;
            default -> true;
        };
    }

    private static boolean isSpectator() {
        return Minecraft.getInstance().gameMode.getPlayerMode() == GameType.SPECTATOR;
    }

    private static Vector3d getEyePosition() {
        Objects.requireNonNull(Minecraft.getInstance().getCameraEntity());
        Vec3 pos = Minecraft.getInstance().getCameraEntity().getEyePosition(CapturedRenderingState.INSTANCE.getTickDelta());
        return new Vector3d(pos.x, pos.y, pos.z);
    }

    public static class WorldInfoUniforms {
        public static void addWorldInfoUniforms(UniformHolder uniforms) {
            ClientLevel level = Minecraft.getInstance().level;
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "bedrockLevel", () -> {
                if (level != null) {
                    return level.dimensionType().minY();
                }
                return 0;
            });
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "cloudHeight", () -> {
                if (level != null) {
                    return ((Float)Minecraft.getInstance().gameRenderer.getMainCamera().attributeProbe().getValue(EnvironmentAttributes.CLOUD_HEIGHT, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false))).floatValue();
                }
                return 192.0;
            });
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heightLimit", () -> {
                if (level != null) {
                    return level.dimensionType().height();
                }
                return 256;
            });
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "logicalHeightLimit", () -> {
                if (level != null) {
                    return level.dimensionType().logicalHeight();
                }
                return 256;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasCeiling", () -> {
                if (level != null) {
                    return level.dimensionType().hasCeiling();
                }
                return false;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasSkylight", () -> {
                if (level != null) {
                    return level.dimensionType().hasSkyLight();
                }
                return true;
            });
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "ambientLight", () -> {
                if (level != null) {
                    return level.dimensionType().ambientLight();
                }
                return 0.0f;
            });
        }
    }
}

