/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.util.weighted;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import org.slf4j.Logger;

public record Weighted<T>(T value, int weight) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public Weighted {
        if (weight < 0) {
            throw (IllegalArgumentException)Util.pauseInIde((Throwable)new IllegalArgumentException("Weight should be >= 0"));
        }
        if (weight == 0 && SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.warn("Found 0 weight, make sure this is intentional!");
        }
    }

    public static <E> Codec<Weighted<E>> codec(Codec<E> codec) {
        return Weighted.codec(codec.fieldOf("data"));
    }

    public static <E> Codec<Weighted<E>> codec(MapCodec<E> mapCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)mapCodec.forGetter(Weighted::value), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("weight").forGetter(Weighted::weight)).apply((Applicative)instance, Weighted::new));
    }

    public <U> Weighted<U> map(Function<T, U> function) {
        return new Weighted<U>(function.apply(this.value()), this.weight);
    }
}

