/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.processor.condition.ProcessorCondition;
import dev.worldgen.lithostitched.worldgen.processor.enums.BlockType;
import java.util.List;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public record MatchingBlocks(HolderSet<Block> blocks, StatePropertiesPredicate properties, BlockType matchType) implements ProcessorCondition
{
    private static final StatePropertiesPredicate DEFAULT_PREDICATE = new StatePropertiesPredicate(List.of());
    public static final MapCodec<MatchingBlocks> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.BLOCK_SET.fieldOf("blocks").forGetter(MatchingBlocks::blocks), (App)StatePropertiesPredicate.CODEC.fieldOf("properties").orElse((Object)DEFAULT_PREDICATE).forGetter(MatchingBlocks::properties), (App)BlockType.CODEC.fieldOf("match_type").orElse((Object)BlockType.INPUT).forGetter(MatchingBlocks::matchType)).apply((Applicative)instance, MatchingBlocks::new));

    @Override
    public boolean test(WorldGenLevel level, ProcessorCondition.Data data, StructurePlaceSettings settings, RandomSource random) {
        BlockState state = this.matchType.state(data);
        return state.is(this.blocks) && this.properties.matches(state);
    }

    @Override
    public MapCodec<? extends ProcessorCondition> codec() {
        return CODEC;
    }
}

