/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.SurfaceSnap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public record AlternateJigsawConfig(Holder<StructureTemplatePool> startPool, Optional<Identifier> startJigsawName, IntProvider size, boolean fixedRotation, HeightProvider startHeight, boolean useExpansionHack, Optional<Either<SurfaceSnap, Heightmap.Types>> startProjection, MaxDistance maxDistanceFromCenter, List<PoolAliasBinding> poolAliases, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
    public static final MapCodec<AlternateJigsawConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(AlternateJigsawConfig::startPool), (App)Identifier.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(AlternateJigsawConfig::startJigsawName), (App)IntProvider.codec((int)0, (int)128).fieldOf("size").forGetter(AlternateJigsawConfig::size), (App)Codec.BOOL.optionalFieldOf("fixed_rotation", (Object)false).forGetter(AlternateJigsawConfig::fixedRotation), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(AlternateJigsawConfig::startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(AlternateJigsawConfig::useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(AlternateJigsawConfig::projectStartToHeightmap), (App)Codec.either(SurfaceSnap.CODEC, (Codec)Heightmap.Types.CODEC).optionalFieldOf("start_projection").forGetter(AlternateJigsawConfig::startProjection), (App)MaxDistance.CODEC.fieldOf("max_distance_from_center").forGetter(AlternateJigsawConfig::maxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(AlternateJigsawConfig::poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DimensionPadding.ZERO).forGetter(AlternateJigsawConfig::dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.APPLY_WATERLOGGING).forGetter(AlternateJigsawConfig::liquidSettings)).apply((Applicative)instance, AlternateJigsawConfig::create));

    public static AlternateJigsawConfig create(Holder<StructureTemplatePool> startPool, Optional<Identifier> startJigsawName, IntProvider size, boolean fixedRotation, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> legacyHeightmapProjection, Optional<Either<SurfaceSnap, Heightmap.Types>> startProjection, MaxDistance maxDistanceFromCenter, List<PoolAliasBinding> poolAliases, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        return new AlternateJigsawConfig(startPool, startJigsawName, size, fixedRotation, startHeight, useExpansionHack, legacyHeightmapProjection.map(Either::right).or(() -> startProjection), maxDistanceFromCenter, poolAliases, dimensionPadding, liquidSettings);
    }

    public AlternateJigsawConfig setPoolAliases(List<PoolAliasBinding> poolAliases, boolean append) {
        ArrayList<PoolAliasBinding> mergedAliases = new ArrayList<PoolAliasBinding>();
        if (append) {
            mergedAliases.addAll(this.poolAliases);
        }
        mergedAliases.addAll(poolAliases);
        return new AlternateJigsawConfig(this.startPool, this.startJigsawName, this.size, this.fixedRotation, this.startHeight, this.useExpansionHack, this.startProjection, this.maxDistanceFromCenter, mergedAliases, this.dimensionPadding, this.liquidSettings);
    }

    private Optional<Heightmap.Types> projectStartToHeightmap() {
        if (this.startProjection.isPresent()) {
            return (Optional)this.startProjection.get().map(surfaceSnap -> Optional.empty(), Optional::of);
        }
        return Optional.empty();
    }

    public record MaxDistance(int horizontal, int vertical) {
        private static final Codec<Integer> BASE_CODEC = Codec.intRange((int)1, (int)128);
        private static final Codec<MaxDistance> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BASE_CODEC.fieldOf("horizontal").forGetter(MaxDistance::horizontal), (App)ExtraCodecs.intRange((int)1, (int)DimensionType.Y_SIZE).optionalFieldOf("vertical", (Object)DimensionType.Y_SIZE).forGetter(MaxDistance::vertical)).apply((Applicative)instance, MaxDistance::new));
        public static final Codec<MaxDistance> CODEC = Codec.either(FULL_CODEC, BASE_CODEC).xmap(either -> (MaxDistance)either.map(Function.identity(), MaxDistance::new), maxDistance -> maxDistance.horizontal == maxDistance.vertical ? Either.right((Object)maxDistance.horizontal) : Either.left((Object)maxDistance));

        public MaxDistance(int value) {
            this(value, value);
        }
    }
}

