/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.neoforge;

import io.github.steveplays28.noisium.Noisium;
import io.github.steveplays28.noisium.neoforge.config.NoisiumNeoForgeConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;

@Mod(value="noisium")
public class NoisiumNeoForge {
    public NoisiumNeoForge(IEventBus modBus, ModContainer container) {
        block7: {
            Noisium.initialize();
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)NoisiumNeoForgeConfig.SPEC, "noisium-client.toml");
            try {
                try {
                    Class.forName("net.minecraft.client.Minecraft");
                }
                catch (ClassNotFoundException cnfe) {
                    Noisium.LOGGER.info("Client classes not found; skipping config screen registration");
                }
                if (Thread.currentThread() == null) break block7;
                try {
                    Class.forName("net.minecraft.client.Minecraft");
                    Class<?> screenFactoryClass = Class.forName("net.neoforged.neoforge.client.gui.IConfigScreenFactory");
                    Object screenFactory = Proxy.newProxyInstance(screenFactoryClass.getClassLoader(), new Class[]{screenFactoryClass}, (proxy, method, args) -> {
                        try {
                            Class<?> screenClass;
                            Class<?> configScreenClass = Class.forName("net.neoforged.neoforge.client.gui.ConfigurationScreen");
                            for (screenClass = args[1].getClass().getSuperclass(); screenClass != null && !screenClass.getSimpleName().equals("Screen"); screenClass = screenClass.getSuperclass()) {
                            }
                            if (screenClass == null) {
                                Noisium.LOGGER.error("Could not find Screen class!");
                                return args[1];
                            }
                            Constructor<?> constructor = configScreenClass.getConstructor(Class.forName("net.neoforged.fml.ModContainer"), screenClass);
                            return constructor.newInstance(container, args[1]);
                        }
                        catch (Exception e) {
                            Noisium.LOGGER.error("Failed to create config screen: " + e.getMessage());
                            return args[1];
                        }
                    });
                    Supplier<Object> factorySupplier = () -> screenFactory;
                    for (Method method2 : container.getClass().getMethods()) {
                        if (!method2.getName().equals("registerExtensionPoint") || method2.getParameterCount() != 2) continue;
                        method2.invoke((Object)container, screenFactoryClass, factorySupplier);
                        Noisium.LOGGER.info("Successfully registered NeoForge config screen");
                        break;
                    }
                }
                catch (ClassNotFoundException screenFactoryClass) {
                }
            }
            catch (Exception e) {
                Noisium.LOGGER.error("Failed to register config screen factory: " + e.getMessage());
            }
        }
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == NoisiumNeoForgeConfig.SPEC) {
            NoisiumNeoForgeConfig.syncToSharedConfig();
            Noisium.LOGGER.info("Loaded NeoForge config");
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == NoisiumNeoForgeConfig.SPEC) {
            NoisiumNeoForgeConfig.syncToSharedConfig();
            Noisium.LOGGER.info("Reloaded NeoForge config");
        }
    }
}

