/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.config.ConfigHandler;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.server.permissions.PermissionSetSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tectonic {
    public static final String MOD_ID = "tectonic";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tectonic");
    public static int BLENDING_VERSION = 1;
    public static String BLENDING_KEY = "tectonic:blending_version";

    public static void init(Path folder) {
        ConfigHandler.load(folder.resolve("tectonic.json"));
    }

    public static Identifier idVanilla(String name) {
        return Identifier.withDefaultNamespace((String)name);
    }

    public static Identifier id(String name) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static int getBlendingVersion(CompoundTag tag) {
        return tag.getIntOr(BLENDING_KEY, 0);
    }

    public static boolean canRunCommand(CommandSourceStack stack) {
        return Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS).test((PermissionSetSupplier)stack);
    }

    public static <T, U> Codec<T> withAlternative(Codec<T> primary, Codec<U> alternative, Function<U, T> converter) {
        return Codec.either(primary, alternative).xmap(either -> either.map(v -> v, converter), Either::left);
    }

    public static boolean isEnabled() {
        return ConfigHandler.getState().general.modEnabled;
    }
}

