/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.map.graphics.OpenGlHelper;
import xaero.map.icon.XaeroIconAtlas;

public class ImprovedFramebuffer
extends TextureTarget {
    private static Field MAIN_RENDER_TARGET_FIELD = ReflectionUtils.getFieldReflection(Minecraft.class, (String)"mainRenderTarget", (String)"field_1689", (String)"Lnet/minecraft/class_276;", (String)"f_91042_");
    private static RenderTarget mainRenderTargetBackup;
    private static GpuTextureView outputColorTextureOverrideBU;
    private static GpuTextureView outputDepthTextureOverrideBU;
    private GpuSampler sampler = XaeroRenderType.getSimpleSampler((FilterMode)FilterMode.LINEAR);
    private RenderSetup.TextureAndSampler tas;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(null, width, height, useDepthIn);
        GpuTextureView textureView = this.getColorTextureView();
        if (textureView == null) {
            return;
        }
        this.tas = new RenderSetup.TextureAndSampler(this.getColorTextureView(), this.sampler);
    }

    public void bindDefaultFramebuffer(Minecraft mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
    }

    public void generateMipmaps() {
        OpenGlHelper.generateMipmaps(this.colorTexture);
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (RenderTarget)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD);
            outputColorTextureOverrideBU = RenderSystem.outputColorTextureOverride;
            outputDepthTextureOverrideBU = RenderSystem.outputDepthTextureOverride;
            RenderSystem.outputColorTextureOverride = null;
            RenderSystem.outputDepthTextureOverride = null;
        }
        ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)((Object)this));
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)mainRenderTargetBackup);
            if (RenderSystem.outputColorTextureOverride == null && RenderSystem.outputDepthTextureOverride == null) {
                RenderSystem.outputColorTextureOverride = outputColorTextureOverrideBU;
                RenderSystem.outputDepthTextureOverride = outputDepthTextureOverrideBU;
            }
            mainRenderTargetBackup = null;
            outputColorTextureOverrideBU = null;
            outputDepthTextureOverrideBU = null;
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.forceAsMainRenderTarget();
    }

    public void setColorTexture(GpuTexture texture, GpuTextureView textureView) {
        if (this.colorTexture == texture && this.colorTextureView == textureView) {
            return;
        }
        this.colorTexture = texture;
        this.colorTextureView = textureView;
        if (textureView == null) {
            this.tas = null;
            return;
        }
        this.tas = new RenderSetup.TextureAndSampler(textureView, this.sampler);
    }

    public void setColorTexture(XaeroIconAtlas atlas) {
        this.setColorTexture(atlas.getTextureId(), atlas.getTextureView());
    }

    public void setDepthTexture(GpuTexture depthTexture, GpuTextureView textureView) {
        this.depthTexture = depthTexture;
        this.depthTextureView = textureView;
    }

    public GpuSampler getSampler() {
        return this.sampler;
    }

    public void setSampler(GpuSampler sampler) {
        if (this.sampler == sampler) {
            return;
        }
        this.sampler = sampler;
        if (this.colorTextureView != null) {
            this.tas = new RenderSetup.TextureAndSampler(this.colorTextureView, sampler);
        }
    }

    public void closeColorTexture() {
        this.colorTextureView.close();
        this.colorTexture.close();
    }

    public void closeDepthTexture() {
        this.depthTextureView.close();
        this.depthTexture.close();
    }

    public RenderSetup.TextureAndSampler getTas() {
        return this.tas;
    }
}

